(define-module (ui openldap selected_dn ajax)
    :use-module (alterator ajax)
    :use-module (alterator woo)
    :use-module (alterator card-index)
    :use-module (alterator str)
    :use-module (alterator effect)
    :export (init))

(define *rootdn* "")
(define *rootpw* "")
(define *bind_info* "")

(define (ui-read)
  (form-update-value "bdn" (form-value "name"))
  (test_bind)
  (form-update-enum "actions" 
	(woo-list "/openldap/avail_actions" 
	    'language (form-value "language")))
  (form-update-enum "container_dn"
	(woo-list "/openldap/present_containers" 
	    'base (form-value "name") 
	    'language (form-value "language")))
    (let ((available-list (woo-list "/openldap/available_containers" 
	    'base (form-value "name") 
	    'language (form-value "language"))))
	    (form-update-enum "available_new" available-list)
;	(if (null? available-list)
;	(begin
;	    (form-update-visibility "create-containers_btn" #f)
;	    (form-update-visibility "addcontainer_area" #f))
;	(begin
;	    (form-update-visibility "create-containers_btn" #t)
;	    (form-update-visibility "addcontainer_area" #t)
;	    (form-update-enum "available_new" available-list))
;	)
    )
    (form-update-value "plus_containers_new" "")
)

(define (test_bind)
    (if (not (string-contains-ci *rootdn* (form-value "name")))
      (begin
	(let* ((data (woo-read "/openldap/selected_dn" 'name (form-value "name"))))
	    (set! *bind_info* (woo-get-option (car data) 'bind_info))
	    (set! *rootdn* (woo-get-option (car data) 'rootdn))
	    (set! *rootpw* (woo-get-option (car data) 'rootpw))
	    (form-update-value "bind_rootdn" *rootdn*)
	    (form-update-value "bind_rootpw" *rootpw*)
	)))
    (bind_request)
)

(define (bind_request)
    (if (equal? *bind_info* "present")
      (begin
	(form-update-visibility "main_table" #t)
	(form-update-visibility "need_bind_info" #f))
      (begin
	(form-update-visibility "main_table" #f)
	(form-update-visibility "need_bind_info" #t)))
)

(define (set_bind)
    (if (not (string-null? (form-value "bind_rootpw")))
       (begin
	(set! *rootpw* (form-value "bind_rootpw"))
	(set! *rootdn* (form-value "bind_rootdn"))
	(set! *bind_info* "present")))
    (bind_request)
)

(define (upgrade_dn)
    (woo "upgrade" "/openldap/exp_dn" 
        'base (form-value "name")
        'binddn *rootdn*
        'bindpw *rootpw*
        'containers (form-value "available_new")
        'plus_containers (form-value "plus_containers_new")
        'language (form-value "language"))
    (ui-read)
)

(define (download-ldif)
    (form-replace "/openldap/selected_dn/download" 'base (form-value "name"))
)

(define (return)
    (form-replace "/openldap"))

(define (init)
    (ui-read)
    (form-bind "bind_btn" "click" set_bind)
    (form-bind "return_to" "click" return)
    (form-bind "export_to_ldif_btn" "click" download-ldif)
    (form-bind "create-containers_btn" "click" upgrade_dn)
)
