(define-module (ui openvpn-server clients ajax)
			   :use-module (srfi srfi-2)
			   :use-module (alterator ajax)
			   :use-module (alterator woo)
			   :export (init))

(define (get-addr network)
  (and network
	   (car (string-split network #\/))))

(define (get-netmask network)
  (and network
	   (cadr (string-split network #\/))))

(define (read-client client)
  (if (and client
		   (not (string=? client "")))
	(catch/message
	  (lambda()
		(let* ((cmd (woo-read-first "/openvpn-server/clients" 'client_name client))
			   (networks (woo-list "/openvpn-server/avail_clients_networks" 'client_name client))
			   (first-value (if (null? networks) #f (woo-get-option (car networks) 'name))))
		  (form-update-enum "clients_networks" networks)
		  (form-update-value "client_name" client)
		  (form-update-value "clients" client)
		  (form-update-value "clients_networks" first-value)
		  (form-update-value-list '("client_ns" "client_domain") cmd)
		  (update-client-net-values first-value))))
	(form-update-enum "clients_networks" '())))

(define (update-interface client)
  (form-update-enum "clients" (woo-list "/openvpn-server/avail_clients"))
  (form-update-enum "client_netmask" (woo-list "/openvpn-server/avail_masks"))
  (read-client (or client (woo-get-option (woo-read-first "/openvpn-server/clients") 'client_name))))

(define (update-client-net-values network)
  (and network
	   (begin
		 (form-update-value "client_net" (get-addr network))
		 (form-update-value "client_netmask" (get-netmask network)))))

(define (write-config reason)
  (catch/message
	(lambda()
	  (apply woo-write
			 "/openvpn-server"
			 'operation reason
			 (form-value-list
			   '("client_name" "client_net" "client_netmask" "language"))))))

(define (add-client-network)
  (catch/message
	(lambda()
	  (apply woo-write
			 "/openvpn-server"
			 'operation "add-client-network"
			 (form-value-list
			   '("client_name" "client_net" "client_netmask" "language")))))
  (update-interface (form-value "client_name")))

(define (remove-client-network)
  (and-let* ((network (form-value "clients_networks"))
			 (addr (get-addr network))
			 (mask (get-netmask network)))
			(catch/message
			  (lambda()
				(woo-write
				  "/openvpn-server"
				  'operation "remove-client-network"
				  'client_name (form-value "clients")
				  'client_net addr
				  'client_netmask mask
                  'language (form-value "language"))))
			(update-interface #f)))

(define (apply-client-ns)
  (catch/message
	(lambda()
	  (apply woo-write
			 "/openvpn-server"
			 'operation "client-ns-domain"
			 'client_name (or (form-value "clients") "")
			 (form-value-list
			   '("client_ns" "client_domain" "language"))))))

(define (back)
  (form-replace "/openvpn-server"))

(define (init)
  (update-interface #f)
  (form-bind "clients" "change" (lambda() (read-client (form-value "clients"))))
  (form-bind "clients_networks" "change" (lambda() (update-client-net-values (form-value "clients_networks"))))
  (form-bind "add_network" "click" add-client-network)
  (form-bind "remove_network" "click" remove-client-network)
  (form-bind "apply-client-ns" "click" apply-client-ns)
  (form-bind "back" "click" back))

