(document:surround "/std/frame")

(define (stop)
  (remove-mailbox message-handler)
  (remove-mailbox error-handler))

;;; Feature: counter
(define *total* (make-cell 0))
(define (total++ value)
  (cell-set! *total* (+ (cell-ref *total*) value)))

(define (string-prefix-at-pos str prefix pos)
  (and (string-prefix? prefix str)
       (list-ref (string-cut str #\:) pos)))

;;; Feature: error message
(define *error-text* (make-cell '()))

(define (error-handler msg)
  (and-let* ((txt (cond-plistq 'error msg #f)))
            (cell-set! *error-text* (append1 (cell-ref *error-text*) txt))))

(define (stage v)
  (cell-set! *total* 0)
  (progress maximum 0 value 0)
  (stage-l text (bold v))
  (status-l text ""))

(define (message-handler args)
  (and-let* ((msg (cond-plistq 'message args #f)))
            (cond
             ;;stages
             ((string=? "pkg-install:stage-index" msg)
              (stage (_ "Building packages list")))
             ((string=? "pkg-install:stage-rpm" msg)
              (stage (_ "Installing base system")))
             ((string=? "pkg-install:stage-install-base" msg)
              (stage (_ "Installing software"))
              (status-l text (_ "Loading package information...")))
             ((string=? "pkg-install:stage-install-rest" msg)
              (stage (_ "Installing additional software"))
              (status-l text (_ "Loading package information...")))

             ;;yesno/finish/change
	     ((string-prefix? "apt-get:media-change:" msg)
              (stop)
              (let* ((msg (string-cut msg #\:))
                     (drive (list-ref msg 2))
                     (name (list-ref msg 3)))
                (frame:replace "/pkg/cdrom"
		               'drive drive
			       'name name
			       'error-text (cell-ref *error-text*)
			       'total (cell-ref *total*))))
	     ((string=? msg "apt-get:wait-yes-no:")
	      (woo-write "/pkg-install/notify" 'message "y")) ;;always yes to confirmation
             ((string-prefix-at-pos msg "pkg-install:finish:" 2) =>
              (lambda(result)
                (stop)
                (if (string=? result "0")
		    (frame:next)
		    (frame:replace "/pkg/error"
		                   'message
		                   (string-join (reverse (cell-ref *error-text*)) (string #\newline) )))))
             ;;status collection
             ((string-prefix-at-pos msg "apt-get:status:upgrade:" 3) =>
              (lambda(count)
                (total++ (string->number count))))
             ((string-prefix-at-pos msg "apt-get:status:install:" 3) =>
              (lambda(count)
                (total++ (string->number count))))

             ;;download progress
             ((string-match "^Get:[0-9]+" msg)
	      (progress text (_ "Acquiring packages..."))
	      (progress value (+ (progress value) 1))
	      (progress maximum (cell-ref *total*)))

             ;;install progress
             ((string-prefix?  "Preparing..." msg)
              (progress text (_ "Installing packages..."))
              (progress maximum (cell-ref *total*) value 0))
             ((string-match "^([^[:blank:]#]+)[[:space:]]*#.+" msg) =>
              (lambda(m)
	        (progress value (+ (progress value) 1))
		(status-l text (match:substring m 1)))))))

;;; UI

(frame:on-back (thunk (frame:replace "/pkg/groups") 'cancel))

(define slideshow (make-widget "slideshow"))

(box
  orientation "vertical"
  margin 10
  (slideshow text "/usr/share/install2/slideshow")
  (label)
  (document:id stage-l (label))
  (document:id progress (progressbar maximum 1 value 1 text (_ "Preparing...")))
  (document:id status-l (label)))

;;; Logic
(document:root (when loaded
                 (and (global 'frame:next) (frame:next-activity #f))
                 (and (global 'frame:next) (frame:back-activity #f))
                 (add-mailbox message-handler)
                 (add-mailbox error-handler)
		 (and (global 'total) (total++ (global 'total)))
		 (and (global 'error-text)
		      (cell-set! *error-text* (append (cell-ref *error-text*) (global 'error-text))))
                 (if (global 'notify)
                     (woo-write "/pkg-install/notify" 'message (global 'notify))
                     (woo-write "/pkg-install" 'lists (global 'lists)))))
