(define-module (ui pkg sources ajax)
	       :use-module (alterator ajax)
	       :use-module (alterator woo)
	       :export (init))

(define (ui-advanced)
  (form-replace "/pkg/sources/mirrors" 'name (form-value "name")))

(define (ui-write)
  (catch/message
    (lambda()
      (apply woo-write "/pkg-sources"
        'commit #t
        'language (form-value "language")
        (form-value-list '("name" "uri")))
      ;; update list with comments and current state
      (ui-list (form-value "name")))))

(define (ui-read)
  (catch/message
    (lambda()
      (let ((name (form-value "name"))
            (language (form-value "language")))
	(form-update-enum
	  "uri"
	  (woo-list "/pkg-sources/avail_mirror" 'name name 'language language))
	(form-update-value-list
	  '("uri")
	  (woo-read-first "/pkg-sources" 'name name 'language language))))))

(define (ui-list . name)
  (catch/message
    (lambda()
      (let ((name-list (woo-list "/pkg-sources/avail_repository" 'language (form-value "language"))))
	(form-update-enum "name" name-list)
	(cond
	  ((pair? name)
	    (form-update-value "name" (car name)))
	  ((pair? name-list)
	    (form-update-value "name" (woo-get-option (car name-list) 'name))))
	(or (null? name-list) (ui-read))))))

(define (init)
  (ui-list)
  (form-bind "name" "change" ui-read)
  (form-bind "advanced_button" "click" ui-advanced)
  (form-bind "change_button" "click" ui-write))
