(document:surround "/std/frame")

;; UI

(gridbox columns "0;100"
	 margin "10"

	 (label text (_ "Repositories:") colspan 2)

	 (listbox colspan 2 name "name")

	 (hbox
	       (label text (_ "Source URI:") align "right")
	       (combobox name "uri"))
	 (button text (_ "Change") align "left" name "change_button")

	 (label colspan 2)

	 (spacer)
	 (button text (_ "Advanced...") align "left" name "advanced_button"))

;; Functions

(define (ui-advanced)
  (form-replace "/pkg/sources/mirrors" 'name (form-value "name")))

(define (ui-write)
  (catch/message
    (lambda()
      (apply woo-write "/pkg-sources"
        'commit #t
        'language (form-value "language")
        (form-value-list '("name" "uri")))
      ;; update list with comments and current state
      (ui-list (form-value "name")))))

(define (ui-read)
  (catch/message
    (lambda()
      (let ((name (form-value "name"))
            (language (form-value "language")))
	(form-update-enum
	  "uri"
	  (woo-list "/pkg-sources/avail_mirror" 'name name 'language language))
	(form-update-value-list
	  '("uri")
	  (woo-read-first "/pkg-sources" 'name name 'language language))))))

(define (ui-list . name)
  (catch/message
    (lambda()
      (let ((name-list (woo-list "/pkg-sources/avail_repository" 'language (form-value "language"))))
	(form-update-enum "name" name-list)
	(cond
	  ((pair? name)
	    (form-update-value "name" (car name)))
	  ((pair? name-list)
	    (form-update-value "name" (woo-get-option (car name-list) 'name))))
	(or (null? name-list) (ui-read))))))

(document:root
  (when loaded
    (ui-list)
    (form-bind "name" "change" ui-read)
    (form-bind "advanced_button" "click" ui-advanced)
    (form-bind "change_button" "click" ui-write)))
