(define-module (ui pkg sources mirrors ajax)
    :use-module (alterator ajax)
    :use-module (alterator woo)
    :export (init))

(define (ui-read)
  (catch/message
    (lambda()
      (form-update-enum
	"uri"
	(woo-list "/pkg-sources/avail_mirror"
		  'name (form-value "name")
		  'language (form-value "language")))
      (form-update-value-list
	'("label" "uri")
	(woo-read-first "/pkg-sources"
			'name (form-value "name")
			'language (form-value "language"))))))

(define (ui-add)
  (catch/message
    (lambda()
      (woo-write "/pkg-sources"
		 'new #t
		 'name (form-value "name")
		 'language (form-value "language")
		 'new_uri (form-value "new_uri"))
      (form-update-value "new_uri" "")
      (ui-read))))

(define (ui-del)
  (catch/message
    (lambda()
      (woo-write "/pkg-sources"
		 'delete #t
		 'name (form-value "name")
		 'language (form-value "language")
		 'uri (form-value "uri"))
      (ui-read))))

(define (ui-return)
  (form-replace "/pkg/sources"))

(define (init)
  (ui-read)
  (form-bind "add_button"    "click" ui-add)
  (form-bind "del_button"    "click" ui-del)
  (form-bind "ret_button"     "click" ui-return))

