(document:surround "/std/frame")

;; Functions

(define *name* (global 'name))

(define (ui-read)
  (catch/message
    (lambda()
      (form-update-enum
	"uri"
	(woo-list "/pkg-sources/avail_mirror"
		  'name *name*
		  'language (form-value "language")))
      (form-update-value-list
	'("label" "uri")
	(woo-read-first "/pkg-sources"
			'name *name*
			'language (form-value "language"))))))

(define (ui-add)
  (catch/message
    (lambda()
      (woo-write "/pkg-sources"
		 'new #t
		 'name *name*
		 'language (form-value "language")
		 'new_uri (form-value "new_uri"))
      (form-update-value "new_uri" "")
      (ui-read))))

(define (ui-del)
  (catch/message
    (lambda()
      (woo-write "/pkg-sources"
		 'delete #t
		 'name *name*
		 'language (form-value "language")
		 'uri (form-value "uri"))
      (ui-read))))

(define (ui-return)
  (form-replace "/pkg/sources"))

;; UI

(gridbox
  columns "100;0"
  margin "10"

  (hbox align "left"
       (label text (bold (_ "Repository:")))
       (label colspan 2 name "label"))
  (label colspan 2)

  (label text  (_ "New source:") colspan 2)
  (edit name "new_uri")
  (button text (_ "Add") name "add_button")

  (label text (_ "Available sources:") colspan 2)
  (listbox name "uri")
  (button text (_ "Delete") name "del_button" align "top")

  (label colspan 2)
  (hbox colspan 2 align "left"
	(button text (_ "Return") align "left" name "ret_button")))

(document:root
  (when loaded
    (ui-read)
    (form-bind "add_button"    "click" ui-add)
    (form-bind "del_button"    "click" ui-del)
    (form-bind "ret_button"     "click" ui-return)))
