(define-module (ui postfix-dovecot ajax)
    :use-module (alterator ajax)
    :use-module (alterator woo)
    :use-module (alterator effect)
    :export (init))

(define (ui-read)
  (form-update-value-list
    (woo-read-first "/postfix-dovecot")))

(define (ui-write)
  (catch/message
    (lambda()
      (apply woo-write "/postfix-dovecot"
	     'language (form-value "language")
	     (form-value-list))
      (ui-read)
      (update-effect))))

(define (init)
  (form-update-enum "mode"
    (woo-list "/postfix-dovecot/modes" 'language (form-value "language")))

  (ui-read)

  (effect-show "relay" "mode" "relay")
  (effect-show "mx" "mode" "mx")
  (effect-show "auth" "auth_state" #t)
  (effect-show "recipients" "filter_recipients" #t)
  (init-effect)

  (form-bind "apply_button" "click" ui-write))
