(define-module (ui quota ajax)
	       :use-module (alterator ajax)
	       :use-module (alterator algo)
	       :use-module (alterator woo)
	       :export (init))

(define (ui-list)
  (let ((fs-list (woo-list "/quota/fs"))
	(uid-list (woo-list "/quota/users" )))

	(form-update-enum "fs" fs-list)
	(form-update-enum  "uid" uid-list)
	(if (pair? fs-list)
	  (form-update-value "fs" (woo-get-option (car fs-list) 'name)))
	(if (pair? uid-list)
	  (form-update-value "uid" (woo-get-option (car uid-list) 'name)))
	(ui-read)))

(define (ui-read)
  (catch/message
    (lambda()
      (let ((fs (form-value "fs"))
	    (uid (form-value "uid")))
	(and (string? fs)
	     (string? uid)
	     (form-update-value-list
	       (woo-read-first "/quota" 'fs fs 'uid uid)))))))

(define (ui-write)
  (catch/message
    (lambda()
      (apply woo-write "/quota"
	     'language (form-value "language")
	     (form-value-list))
      (ui-read))))

(define (init)
  (ui-list)
  (form-bind "fs"  "change"  ui-read)
  (form-bind "uid" "change"  ui-read)

  (form-bind "apply_button" "click" ui-write)
  (form-bind "reset_button" "click" ui-read))
