(document:surround "/std/frame")

(define (on-change-fs)
  (let ( (flist (woo-list "/quota/fs")) )

    (if (string= (form-value "fs") "")
      (form-update-value "fs" (woo-get-option (cond-car flist) 'name)))

    (let* ( (fs (form-value "fs"))
            (uid (form-value "uid"))
            (ulist (woo-list "/quota/users" 'fs fs)) )

       (form-update-enum "uid" ulist)

       (form-update-value "uid"
         (if (string= uid "") (woo-get-option (cond-car ulist) 'name) uid)) )
    (on-change-user) ))

(define (on-change-user)
  (catch/message (lambda()
    (let ((fs (form-value "fs"))
          (uid (form-value "uid")) )
      (let ((data (woo-read-first "/quota" 'fs fs 'uid uid)))
        (form-update-value "b_used" (woo-get-option data 'b_used))
        (form-update-value "b_soft" (woo-get-option data 'b_soft))
        (form-update-value "b_hard" (woo-get-option data 'b_hard))
        (form-update-value "i_used" (woo-get-option data 'i_used))
        (form-update-value "i_soft" (woo-get-option data 'i_soft))
        (form-update-value "i_hard" (woo-get-option data 'i_hard)) )))))

(define (on-apply)
  (catch/message (lambda()
    (apply woo-write "/quota" (form-value-list)) )))

;;

(gridbox columns "1;39;60" margin 20

 (label text (_ "Filesystem:"))
 (combobox name "fs" enumref "/quota/fs" (when changed (on-change-fs)))
 (spacer)

 (label name "uid" text (_ "User:") align "right;top")
 (listbox name "uid" enumref "/quota/users" (when changed (on-change-user)))

 (gridbox columns "1;90;10" margin 20

   (label name "b_used" text (_ "Used disk space:") align "right")
   (edit  name "b_used" activity #f)
   (label name "b_used" text (_ "kb"))

   (label name "b_soft" text (_ "Soft limit:") align "right")
   (edit  name "b_soft")
   (label name "b_soft" text (_ "kb"))

   (label name "b_hard" text (_ "Hard limit:") align "right")
   (edit  name "b_hard")
   (label name "b_hard" text (_ "kb"))

   (label name "i_used" text (_ "Inodes used:") align "right")
   (edit  name "i_used" activity #f)
   (spacer)

   (label name "i_soft" text (_ "Soft limit:") align "right")
   (edit  name "i_soft")
   (spacer)

   (label name "i_hard" text (_ "Hard limit:") align "right")
   (edit  name "i_hard")
   (spacer)

   (spacer)
   (button text (_ "Apply") (when clicked (on-apply)))
   (button text (_ "Reset") (when clicked (on-change-user)))
 )
)
(document:root (when loaded (on-change-fs) ))
