(define-module (ui root ajax)
    :use-module (alterator ajax)
    :use-module (alterator algo)
    :use-module (alterator woo)
    :use-module (alterator effect)
    :export (init
             init-passwordbox
             commit-passwordbox
             ))

;; private passwordbox API

(define (generate-passwordbox)
  (form-update-value-list
    '("passwd_auto")
    (woo-call "/root/generate_password")))

(define (update-passwordbox)
  (form-update-value "passwd_1" "")
  (form-update-value "passwd_2" "")
  (form-update-value "passwd_auto" "")
  (form-update-value "auto" #f)
  (generate-passwordbox)
  (update-effect))

;; public passwordbox API

(define (init-passwordbox)
  ;; effects
  (effect-show "passwd_1" "auto" #f)
  (effect-show "passwd_2" "auto" #f)
  (effect-show "passwd_auto" "auto" #t)
  (effect-show "generate_button" "auto" #t)
  ;; generate button
  (form-bind "generate_button" "click" generate-passwordbox)
  (update-passwordbox))

(define (commit-passwordbox)
  (apply woo-call "/root/change_password"
         'language (form-value "language")
	 (form-value-list '("auto" "passwd_1" "passwd_2" "passwd_auto")))
  (update-passwordbox))

;;; current form specific API

(define (ui-write)
  (form-update-visibility "passwd_message" #f)
  (catch/message
    (lambda()
        (commit-passwordbox)
	(form-update-visibility "passwd_message" #t))))

(define (ui-key-read)
  (catch/message
   (lambda()
     (form-update-enum "key" (woo-call "/root/ssh_key_list")))))

(define (ui-key-add)
  (call-with-form-file
      "key_file"
      (lambda(path)
        (catch/message
          (lambda()
            (woo-call "/root/ssh_key_add"
                      'language (form-value "language")
                      'key_file path)
            (ui-key-read))))))

(define (ui-key-del)
  (catch/message
    (lambda()
        (woo-call "/root/ssh_key_del"
                   'language (form-value "language")
                   'key (form-value "key"))
            (ui-key-read))))

(define (init)
  ;; password
  (init-passwordbox)
  (init-effect)
  (form-bind "apply_button" "click" ui-write)
  ;; ssh keys
  (ui-key-read)
  (form-bind-upload "add_key_button" "click" "key_file" ui-key-add)
  (form-bind "del_key_button" "click" ui-key-del))
