(document:surround "/std/frame")

;;; Functions

(define (ui-generate)
  (form-update-value-list
    '("passwd_auto")
    (woo-call "/root/generate_password")))

(define (ui-read)
  (form-update-value "passwd_1" "")
  (form-update-value "passwd_2" "")
  (form-update-value "passwd_auto" "")
  (form-update-value "auto" #f)
  (ui-generate)
  (update-effect))

(define (ui-write)
  (catch/message
    (lambda()
	(apply woo-call "/root/change_password"
		   'language (form-value "language")
		   (form-value-list '("auto" "passwd_1" "passwd_2" "passwd_auto")))
	(ui-read))))

(define (ui-init)
  (effect-show "passwd_1" "auto" #f)
  (effect-show "passwd_2" "auto" #f)
  (effect-show "passwd_auto" "auto" #t)
  (effect-show "generate_button" "auto" #t)
  (init-effect)
  (ui-read)
  (form-bind "generate_button" "click" ui-generate)
  (or (global 'frame:next)
      (form-bind "apply_button" "click" ui-write)))

;;; UI

(gridbox columns "20;60;20"
	(spacer)
	(label text (_ "Setup password for system administrator:"))
	(spacer)

	(spacer)
	(gridbox
	  columns "100;0"
	  (checkbox text (_ "Generate automatically") name "auto")
	  (spacer)
	  (edit name "passwd_1" echo "stars" visibility #f focus #t)
	  (label name "passwd_1" text (small (_ "(enter passphrase)")) visibility #f)
	  (edit name "passwd_2" echo "stars" visibility #f)
	  (label name "passwd_1" text (small (_ "(repeat passphrase)")) visibility #f)
	  (edit name "passwd_auto" visibility #f)
	  (button text (_ "Generate") name "generate_button" visibility #f)
	  (label colspan 2 name "passwd_auto" visibility #f))
	(spacer)

	(label colspan 3)

	(spacer)
	(if (global 'frame:next)
	    (label)
	    (button text (_ "Apply") name "apply_button" align "left"))
	(spacer))

;;; Logic

(frame:on-next (thunk (or (ui-write) 'cancel)))

(document:root
  (when loaded
   (ui-init)
   (and (global 'frame:next) (frame:back-activity #f))))
