(define-module (ui services ajax)
    :use-module (alterator ajax)
    :use-module (alterator woo)
    :use-module (alterator card-index)
    :export (init))

(define (ui-read)
  (let ((name (f-get-ci-value "name") ))
    (f-reset "/services" 'name name)
    (f-update-list "change_status" (string-append "/services/" name))
    (form-update-value "title" name) ))

(define (ui-write)
  (let ((name (f-get-ci-value "name") ))
    (f-submit "/services" 'name name)
    (f-update-list "change_status" (string-append "/services/" name))
    (f-reset "/services" 'name name) ))

(define (init)
  (f-update-ci-list "name" "/services")
  (ui-read)
  (form-bind "name"   "change" ui-read)
  (form-bind "submit" "click"  ui-write)
  (form-bind "reset"  "click"  ui-read) )
