(document:surround "/std/frame")

(gridbox columns "30;70"
  (listbox name "name" header (vector (_ "Services")))

  (groupbox ""
    (label "" name "title")
    (textbox "" alterability #f name "description")
    (label "" name "status")
    (gridbox columns "10;90"
      (label (bold (_ "Change state:")))
      (combobox align "left" name "change_status") )

    (gridbox columns "40;30"
      (checkbox text (_ "Start on boot") name "chkconfig_status")
      (button   text (_ "Apply") name "apply"))))


(define (ui-list)
  (catch/message ( lambda ()
    (let ((data (woo-list "/services")))
     (if (pair? data)
      (let ((name (woo-get-option (cond-car data) 'name)))
       (form-update-enum  "name" data)
       (form-update-value "name" name)
       (ui-read name)
       ))))))

(define (ui-read . n)
  (catch/message ( lambda ()
    (let* ((name (if (pair? n) (car n) (form-value "name")))
           (data (woo-read-first "/services" 'name name)))
        (form-update-value-list `("description" "status" "chkconfig_status") data)
        (form-update-enum  "change_status" (woo-list (string-append "/services/" name)))
        (form-update-value "title" name) ))))

(define (ui-write)
  (catch/message ( lambda () (apply woo-write "/services/" (form-value-list)) ))
  (ui-read))

(define (ui-init)
  (ui-list)
  (form-bind "name"  "change" ui-read)
  (form-bind "apply" "click"  ui-write))

(document:root (when loaded (ui-init)))
