(define-module (ui snort ajax)
    :use-module (alterator ajax)
    :use-module (alterator woo)
    :export (init))

(define (read-state)
  (catch/message
    (lambda()
      (form-update-value-list '("state_enabled") (woo-read-first "/snort/state_enabled"
                                                              'language (form-value "language"))))))

(define (read-statistics)
  (catch/message
    (lambda()
      (form-update-enum "statistics" (woo-list "/snort/events"
                                               'start_date (form-value "start_date")
                                               'start_time (form-value "start_time")
                                               'end_date (form-value "end_date")
                                               'end_time (form-value "end_time"))))))

(define (ui-init)
  (form-update-enum "statistics" '())
  (form-update-enum "details" '())
  (read-state)
  (catch/message
    (lambda()
      (form-update-value-list '("start_date" "start_time" "end_date" "end_time")
                              (woo-read-first "/snort/dates"
                                              'language (form-value "language")))))
  (read-statistics))

(define (on-show)
  (read-statistics))

(define (on-details)
  (catch/message
    (lambda()
      (form-update-enum "details" (woo-list "/snort/details"
                                            'details (form-value "statistics")
                                            'start_date (form-value "start_date")
                                            'start_time (form-value "start_time")
                                            'end_date (form-value "end_date")
                                            'end_time (form-value "end_time")))))
  (read-state))

(define (on-apply-state)
  (catch/message
    (lambda()
      (woo-write "/snort/state_enabled"
                 'state_enabled (form-value "state_enabled")
                 'language (form-value "language")))))

(define (init)
  (form-bind "apply_state_button" "click" on-apply-state)
  (form-bind "details_button" "click" on-details)
  (form-bind "show_button" "click" on-show)
  (ui-init))
