(define-module (ui squid ajax)
  :use-module (srfi srfi-1)
  :use-module (alterator ajax)
  :use-module (alterator woo)
  :export (init))

(define (refresh)
  (catch/message
    (lambda ()
      (form-update-enum "mode" (woo-list "/squid/modes"
                                         'language (form-value "language")))
      (form-update-enum "auth-mode" (woo-list "/squid/auth-modes"
                                              'language (form-value "language")))
      (form-update-enum "groups" (woo-list "/squid/groups"
                                           'language (form-value "language")))
      (form-update-value-list '("status" "mode" "auth-mode" "http_port")
                              (woo-read-first "/squid")))))

(define (refresh-mode)
  (cond
    ((equal? (form-value "mode") "transparent")
     (form-update-activity "auth-mode" #f)
     (form-update-value "auth-mode" "no-auth"))
    (else
      (form-update-activity "auth-mode" #t))))

(define (read-group)
  (let ((group (form-value "groups")))
    (if (and group (not (equal? "" group)))
      (let ((vals (catch/message
                    (lambda ()
                      (woo-read-first (string-append "/squid/groups/"
                                                     group))))))
        (form-update-value "suffix" (woo-get-option vals 'suffix))
        (form-update-value "group" (woo-get-option vals 'label))
        (form-update-value "policy"
                           (if (woo-get-option vals 'deny)
                             "deny"
                             "allow"))))))

(define (save-group)
  (let ((group (form-value "groups")))
    (if (and group (not (equal? "" group)))
      (catch/message
        (lambda ()
          (woo-write (string-append "/squid/groups/" group)
                     'deny (case (string->symbol (form-value "policy"))
                             ((deny) #t)
                             (else #f))
                     'suffix (form-value "suffix")))))))

(define (reconfigure)
  (catch/message
    (lambda ()
      (woo-write "/squid"
                 'mode (form-value "mode")
                 'auth-mode (form-value "auth-mode")
                 'status (form-value "status")
                 'http_port (form-value "http_port")))))

(define (init)
  (form-bind "mode" "change" refresh-mode)
  (form-bind "apply" "click" reconfigure)
  (form-bind "groups" "change" read-group)
  (form-bind "save" "click" save-group)
  (form-bind "networks" "click" (lambda ()
                                  (form-replace "/squid/networks")))
  (form-bind "ports" "click" (lambda ()
                               (form-replace "/squid/safe-ports")))
  (refresh)
  (refresh-mode)
  (read-group))
