(define-module (ui squid domains ajax)
  :use-module (srfi srfi-1)
  :use-module (alterator ajax)
  :use-module (alterator woo)
  :export (init))

(define last-name #f)

(define *new-obj* "*")

(define (is-new-obj? name)
  (and name (equal? name *new-obj*)))

(define *new-obj-label* (_"&lt;new&gt;"))

(define (refresh-domain name)
  (let* ((domain-list (append
                       (catch/message
                         (lambda ()
                           (woo-list "/squid/domains" 'language (form-value "language"))))
                       (if (is-new-obj? name)
                           (list (list *new-obj* 'name *new-obj*
                                        'label *new-obj-label*))
                           '())))
         (name (if (and name
                        (find (lambda (domain)
                                (equal? (woo-get-option domain 'name)
                                        name))
                              domain-list))
                   name
                   (and (not (null? domain-list))
                        (woo-get-option (car domain-list) 'name))))
         (domain-data (if (or (not name)
                              (is-new-obj? name))
                        '()
                        (catch/message
                          (lambda ()
                            (woo-read-first
                              (string-append "/squid/domains/"
                                             name)))))))
    (form-update-enum "name" domain-list)
    (form-update-value "name" name)
    (cond
      (name
        (form-update-value "suffix"
               (woo-get-option domain-data 'suffix))
        (form-update-value "comment"
               (woo-get-option domain-data 'comment))
        (form-update-activity "suffix" #t)
        (form-update-activity "apply" #t)
        (form-update-activity "comment" #t))
      (else
        (form-update-value "suffix" "")
        (form-update-value "comment" "")
        (form-update-activity "suffix" #f)
        (form-update-activity "apply" #f)
        (form-update-activity "comment" #f)))
    (form-update-activity "delete" (not (or (not name)
                                            (is-new-obj? name)
                                            (null? domain-list))))
    (if (not (equal? name *new-obj*))
        (set! last-name name))))

(define (on-domain-change)
  (refresh-domain (or (form-value "name") last-name)))

(define (on-domain-save)
  (let ((name (form-value "name"))
        (suffix (form-value "suffix"))
        (comment (form-value "comment")))
    (cond
     ((is-new-obj? name)
      (let* ((answer (catch/message
                       (lambda ()
                         (woo "read-next" "/squid/domains"))))
             (name (string-append "domain-"
                                  (number->string
                                   (woo-get-option (car answer) 'id)))))
        (catch/message
          (lambda ()
            (woo-new (string-append "/squid/domains/" name)
                     'suffix suffix
                     'comment comment)))
        (refresh-domain name)))
     (else
      (catch/message
        (lambda ()
          (woo-write (string-append "/squid/domains/" name)
                     'suffix suffix
                     'comment comment)))
      (refresh-domain name)))))

(define (go-to-new)
  (refresh-domain *new-obj*))

(define (delete-domain)
  (let ((name (form-value "name")))
    (cond
     ((not (is-new-obj? name))
      (catch/message
        (lambda ()
          (woo-delete (string-append "/squid/domains/" name))))
      (on-domain-change)))))

(define (init)
  (form-bind "name"  "change" on-domain-change)
  (form-bind "apply" "click" on-domain-save)
  (form-bind "new" "click" go-to-new)
  (form-bind "delete" "click" delete-domain)
  (on-domain-change))
