(define-module (ui squid networks ajax)
  :use-module (srfi srfi-1)
  :use-module (alterator ajax)
  :use-module (alterator woo)
  :export (init))

(define last-name #f)

(define *new-obj* "*")

(define (is-new-obj? name)
  (and name (equal? name *new-obj*)))

(define *new-obj-label* (_"&lt;new&gt;"))

(define (refresh-network name)
  (let* ((network-list (append
                        (catch/message
                          (lambda ()
                            (woo-list "/squid/networks" 'language (form-value "language"))))
                        (if (is-new-obj? name)
                            (list (list *new-obj* 'name *new-obj*
                                        'label *new-obj-label*))
                            '())))
         (name (if (and name
                        (find (lambda (network)
                                (equal? (woo-get-option network 'name)
                                        name))
                              network-list))
                   name
                   (and (not (null? network-list))
                        (woo-get-option (car network-list) 'name))))
         (network-data (if (or (not name)
                               (is-new-obj? name))
                        '()
                        (catch/message
                          (lambda ()
                            (woo-read-first
                              (string-append "/squid/networks/"
                                             name)))))))
    (form-update-enum "name" network-list)
    (form-update-value "name" name)
    (cond
      (name
        (form-update-value "address"
               (woo-get-option network-data 'address))
        (form-update-value "comment"
               (woo-get-option network-data 'comment))
        (form-update-activity "address" #t)
        (form-update-activity "apply" #t)
        (form-update-activity "comment" #t))
      (else
        (form-update-value "address" "")
        (form-update-value "comment" "")
        (form-update-activity "address" #f)
        (form-update-activity "apply" #f)
        (form-update-activity "comment" #f)))
    (form-update-activity "delete" (not (or (not name)
                                            (is-new-obj? name)
                                            (null? network-list))))
    (if (not (equal? name *new-obj*))
        (set! last-name name))))

(define (on-network-change)
  (refresh-network (or (form-value "name") last-name)))

(define (on-network-save)
  (let ((name (form-value "name"))
        (address (form-value "address"))
        (comment (form-value "comment")))
    (cond
     ((is-new-obj? name)
      (let* ((answer (catch/message
                       (lambda ()
                         (woo "read-next" "/squid/networks"))))
             (name (string-append "network-"
                                  (number->string
                                   (woo-get-option (car answer) 'id)))))
        (catch/message
          (lambda ()
            (woo-new (string-append "/squid/networks/" name)
                     'address address
                     'comment comment)))
        (refresh-network name)))
     (else
      (catch/message
        (lambda ()
          (woo-write (string-append "/squid/networks/" name)
                     'address address
                     'comment comment)))
      (refresh-network name)))))

(define (go-to-new)
  (refresh-network *new-obj*))

(define (delete-network)
  (let ((name (form-value "name")))
    (cond
     ((not (is-new-obj? name))
      (catch/message
        (lambda ()
          (woo-delete (string-append "/squid/networks/" name))))
      (on-network-change)))))

(define (init)
  (form-bind "name"  "change" on-network-change)
  (form-bind "apply" "click" on-network-save)
  (form-bind "new" "click" go-to-new)
  (form-bind "delete" "click" delete-network)
  (form-bind "back" "click" (lambda ()
                              (form-replace "/squid")))
  (on-network-change))
