(define-module (ui squid safe-ports ajax)
  :use-module (srfi srfi-1)
  :use-module (alterator ajax)
  :use-module (alterator woo)
  :export (init))

(define last-name #f)

(define *new-obj* "*")

(define (is-new-obj? name)
  (and name (equal? name *new-obj*)))

(define *new-obj-label* (_"&lt;new&gt;"))

(define (refresh-port name)
  (let* ((port-list (append
                     (catch/message
                       (lambda () (woo-list "/squid/safe-ports"
                                            'language (form-value "language"))))
                     (if (is-new-obj? name)
                         (list (list *new-obj* 'name *new-obj*
                                        'label *new-obj-label*))
                         '())))
         (name (if (and name
                        (find (lambda (port)
                                (equal? (woo-get-option port 'name)
                                        name))
                              port-list))
                   name
                   (and (not (null? port-list))
                        (woo-get-option (car port-list) 'name))))
         (port-data (if (or (not name)
                               (is-new-obj? name))
                        '()
                        (catch/message
                          (lambda ()
                            (woo-read-first
                              (string-append "/squid/safe-ports/"
                                             name)))))))
    (form-update-enum "name" port-list)
    (form-update-value "name" name)
    (cond
      (name
        (form-update-value "start_port"
               (woo-get-option port-data 'start_port))
        (form-update-value "end_port"
               (woo-get-option port-data 'end_port))
        (form-update-enum "method" (woo-list "/squid/proxy-methods"
                                             'language (form-value "language")))
        (form-update-value "method"
               (woo-get-option port-data 'method))
        (form-update-value "transparent"
               (woo-get-option port-data 'transparent))
        (form-update-value "comment"
               (woo-get-option port-data 'comment))
        (form-update-activity "start_port" #t)
        (form-update-activity "end_port" #t)
        (form-update-activity "apply" #t)
        (form-update-activity "method" #t)
        (form-update-activity "transparent" #t)
        (form-update-activity "comment" #t))
      (else
        (form-update-value "start_port" "")
        (form-update-value "end_port" "")
        (form-update-value "method" "")
        (form-update-value "transparent" #f)
        (form-update-value "comment" "")
        (form-update-activity "start_port" #f)
        (form-update-activity "end_port" #f)
        (form-update-activity "apply" #f)
        (form-update-activity "method" #f)
        (form-update-activity "transparent" #f)
        (form-update-activity "comment" #f)))
    (form-update-activity "delete" (not (or (not name)
                                            (is-new-obj? name)
                                            (null? port-list))))
    (if (not (equal? name *new-obj*))
        (set! last-name name))))

(define (on-port-change)
  (refresh-port (or (form-value "name") last-name)))

(define (on-port-save)
  (let ((name (form-value "name"))
        (start_port (form-value "start_port"))
        (end_port (form-value "end_port"))
        (method (form-value "method"))
        (transparent (form-value "transparent"))
        (comment (form-value "comment")))
    (cond
     ((is-new-obj? name)
      (let* ((answer (catch/message
                       (lambda ()
                         (woo "read-next" "/squid/safe-ports"))))
             (name (string-append "port-"
                                  (number->string
                                   (woo-get-option (car answer)
                                                   'id)))))
        (catch/message
          (lambda ()
            (woo-new (string-append "/squid/safe-ports/" name)
                     'start_port start_port
                     'end_port end_port
                     'method method
                     'transparent transparent
                     'comment comment)))
        (refresh-port name)))
     (else
      (catch/message
        (lambda ()
          (woo-write (string-append "/squid/safe-ports/" name)
                     'start_port start_port
                     'end_port end_port
                     'method method
                     'transparent transparent
                     'comment comment)))
      (refresh-port name)))))

(define (go-to-new)
  (refresh-port *new-obj*))

(define (delete-port)
  (let ((name (form-value "name")))
    (cond
     ((not (is-new-obj? name))
      (catch/message
        (lambda ()
          (woo-delete (string-append "/squid/safe-ports/" name))))
      (on-port-change)))))

(define (init)
  (form-bind "name"  "change" on-port-change)
  (form-bind "apply" "click" on-port-save)
  (form-bind "new" "click" go-to-new)
  (form-bind "delete" "click" delete-port)
  (form-bind "back" "click" (lambda ()
                              (form-replace "/squid")))
  (on-port-change))
