(define-module (ui sslkey ajax)
    :use-module (alterator ajax)
    :use-module (alterator woo)
    :export (init))

(define (ui-update-keys)
  (let* ((keys (woo-list "/sslkey/avail_keys" 'language (form-value "language")))
		 (first-value (if (null? keys) #f (woo-get-option (car keys) 'name))))
	(form-update-enum "keys" keys)
	(form-update-value "keys" first-value)))

(define (on-change)
  (form-replace (format #f "/sslkey/generate?name=~A" (form-value "keys"))))

(define (on-new)
  (form-replace "/sslkey/generate"))

(define (on-delete)
  (woo-write "/sslkey/delete" 'name (form-value "keys" 'language (form-value "language")))
  (form-update-visibility "confirm_delete" #f)
  (form-update-value "delete_all" #f)
  (ui-update-keys))

(define (init)
  (ui-update-keys)
  (form-bind "change_button" "click" on-change)
  (form-bind "new_button" "click" on-new)
  (form-bind "delete_all" "change" (lambda() (form-update-visibility "confirm_delete" (form-value "delete_all"))))
  (form-bind "confirm_delete" "click" on-delete))
