(define-module (ui sslkey generate ajax)
			   :use-module (alterator ajax)
			   :use-module (alterator woo)
			   :use-module (alterator algo)
			   :export (init))

(define *name* (make-cell ""))

(define (backend-path)
  (or (form-value "backend")
	  "/sslkey"))

(define (make-name)
  (or
	(catch/message
	  (lambda()
		(woo-get-option (apply woo-read-first "/sslkey/make-name"
							   (form-value-list
								 '("CN" "C" "L" "O" "OU" "emailAddress")))
						'name)))
	""))

(define (get-or-make-name)
  (let ((name (cell-ref *name*)))
	(if (string=? "" name)
	  (make-name)
	  name)))

(define (get-name)
  (let ((name (cell-ref *name*)))
	(if (string=? "" name)
	  (read-name "/sslkey")
	  name)))

(define (read-name backend)
  (or
	(catch/message
	  (lambda()
		(let ((backend-obj (string-append backend "/sslkey-name")))
		  (woo-get-option (woo-read-first backend-obj) 'name))))
	""))

(define (read-hide backend)
  (catch/message
	(lambda()
	  (let ((backend-obj (string-append backend "/sslkey-hide")))
		(woo-get-option (woo-read-first backend-obj) 'hide)))))

(define (ui-read-defaults backend name)
  (let* ((backend-obj (string-append backend "/sslkey-default"))
		 (cmd (woo-read-first backend-obj 'name name)))
	(form-update-value-list
	  '("CN" "C" "L" "O" "OU" "emailAddress")
	  cmd)))

(define (ui-read backend name)
  (catch/message
    (lambda()
      (let* ((cmd (woo-read-first "/sslkey" 'name name))
             (key_exist (woo-get-option cmd 'key_exist)))
        (if key_exist
          (form-update-value-list
            '("CN" "C" "L" "O" "OU" "emailAddress")
            cmd)
          (and
            backend
            (ui-read-defaults backend name)))
        (form-update-activity "download_sr" key_exist)))))

(define (ui-fields-hide hide)
  (for-each (lambda(item)
			  (form-update-visibility item #f))
			(string-split hide #\;)))

(define (ui-update active)
  (form-update-activity "upload_button" active)
  (form-update-activity "certificate" active)
  (form-update-value "generate_key" (not active))
  (form-update-visibility "confirm_button" (not active)))

(define (reset-name)
  (let ((name (form-value "name")))
	(catch/message
	  (lambda()
		(woo-write
		  "sslkey/reset-name"
		  'name (or
				  name
				  ""))))))

(define (ui-init)
  (form-update-visibility "ca_upload_message" #f)
  (let* ((backend (backend-path))
		 (name (or (form-value "name")
				   (read-name backend)))
		 (hide (or (form-value "hide")
				   (read-hide backend))))
	(and name
		 (cell-set! *name* name))
	(and (string=? "" (cell-ref *name*))
		 (ui-update #f))
	(and hide
		 (not (string=? "" hide))
		 (ui-fields-hide hide))
	(ui-read backend (cell-ref *name*))))

(define (on-upload)
  (form-update-visibility "ca_upload_message" #f)
  (call-with-form-file
	"certificate"
	(lambda(path)
      (and
        (catch/message
          (lambda() (woo-write "/sslkey/upload" 'certificate path 'name *name* 'language (form-value "language"))))
        (form-update-visibility "ca_upload_message" #t)))))

(define (on-confirm)
  (let ((name (get-or-make-name)))
	(catch/message
	  (lambda()
		(apply woo-write "/sslkey"
			   'name name
			   (form-value-list
				 '("CN" "C" "L" "O" "OU" "emailAddress" "language")))))
	(ui-read (backend-path) name)
	(ui-update #t)))

(define (download-csr)
  (form-replace "/sslkey/csr"))

(define (init)
  (ui-init)
  (form-bind-upload "upload_button" "click" "certificate" on-upload)
  (form-bind "generate_key" "change" (lambda() (form-update-visibility "confirm_button" (form-value "generate_key"))))
  (form-bind "download_sr" "click" download-csr)
  (form-bind "confirm_button" "click" (lambda() (begin
												  (ui-update #f)
												  (on-confirm)))))
