(document:surround "/std/frame")

;;; Functions
(define *name* (make-cell ""))

(define (backend-path)
  (or (global 'backend)
	  "/sslkey"))

(define (make-name)
  (or
	(catch/message
	  (lambda()
		(woo-get-option (apply woo-read-first "/sslkey/make-name"
							   (form-value-list
								 '("CN" "C" "L" "O" "OU" "emailAddress")))

						'name)))
	""))

(define (get-or-make-name)
  (let ((name (cell-ref *name*)))
	(if (string=? "" name)
	  (make-name)
	  name)))

(define (get-name)
  (let ((name (cell-ref *name*)))
	(if (string=? "" name)
	  (read-name "/sslkey")
	  name)))

(define (read-name backend)
  (or 
	(catch/message
	  (lambda()
		(let ((backend-obj (string-append backend "/sslkey-name")))
		  (woo-get-option (woo-read-first backend-obj) 'name))))
	""))

(define (read-hide backend)
  (catch/message
	(lambda()
	  (let ((backend-obj (string-append backend "/sslkey-hide")))
		(woo-get-option (woo-read-first backend-obj) 'hide)))))

(define (ui-read-defaults backend name)
  (let* ((backend-obj (string-append backend "/sslkey-default"))
		 (cmd (woo-read-first backend-obj 'name name)))
	(form-update-value-list
	  '("CN" "C" "L" "O" "OU" "emailAddress")
	  cmd)))

(define (ui-read backend name)
  (catch/message
	(lambda()
	  (let ((cmd (woo-read-first "/sslkey" 'name name)))
		(if (woo-get-option cmd 'key_exist)
		  (form-update-value-list
			'("CN" "C" "L" "O" "OU" "emailAddress")
			cmd)
		  (and
			backend
			(ui-read-defaults backend name)))))))

(define (ui-fields-hide hide)
  (for-each (lambda(item)
			  (form-update-visibility item #f))
			(string-split hide #\;)))

(define (ui-update active)
  (form-update-value "generate_key" (not active))
  (form-update-visibility "confirm_button" (not active)))

(define (reset-name)
  (let ((name (global 'name)))
	(catch/message
	  (lambda()
		(woo-write
		  "sslkey/reset-name"
		  'name (or
				  name
				  ""))))))

(define (ui-init)
  (let* ((backend (backend-path))
		 (name (or (global 'name)
				   (read-name backend)))
		 (hide (or (global 'hide)
				   (read-hide backend))))
	(and name
		 (cell-set! *name* name))
	(and (string=? "" (cell-ref *name*))
		 (ui-update #f))
	(and hide
		 (not (string=? "" hide))
		 (ui-fields-hide hide))
	(ui-read backend (cell-ref *name*))))

(define (confirm-export-request)
  (let ((path (export-request value))
		(name (get-name)))
	(or (string=? path "")
		(string=? name "")
		(and
		  (catch/message
			(lambda()
			  (woo-write
				"/sslkey/export-request"
				'path path
				'name name)))
		  (export-request value "")))))

(define (confirm-import-cert)
  (let ((path (import-cert value))
		(name (get-name)))
	(or (string=? path "")
		(string=? name "")
		(and
		  (catch/message
			(lambda()
			  (woo-write
				"/sslkey/import-cert"
				'certificate path
				'name name)))
		  (import-cert value "")))))

(define (on-confirm)
  (let ((name (get-or-make-name)))
	(catch/message
	  (lambda()
		(apply woo-write "/sslkey"
			   'name name
			   (form-value-list
				 '("CN" "C" "L" "O" "OU" "emailAddress")))))
	(ui-read (backend-path) name)
	(ui-update #t)))

(define (ui-exit)
  (document:end))

(define (apply-all)
  (and
	(confirm-export-request)
	(confirm-import-cert)))

(define (ok)
  (and
	(apply-all)
	(ui-exit)))


;;; UI
width 600
height 500

(define fileselect (make-widget 'fileselect))
(define url (make-attribute 'url))
(define value (make-attribute 'value))
(define filter (make-attribute 'filter))
(define hints (make-attribute 'hints))

(gridbox
  columns "0;100"
  margin 10

  (label colspan 2 text (bold (_ "SSL settings:")))
  (label text (_ "Common Name (CN):") name "CN" align "left")
  (edit name "CN")
  ;;
  (label text (_ "Country (C):") name "C" align "left")
  (edit name "C")
  ;;
  (label text (_ "Location (L):") name "L" align "left")
  (edit name "L")
  ;;
  (label text (_ "Organization (O):") name "O" align "left")
  (edit name "O")
  ;;
  (label text (_ "Organizational Unit (OU):") name "OU" align "left")
  (edit name "OU")
  ;;
  (label text (_ "E-mail address:") name "emailAddress" align "left")
  (edit name "emailAddress")
  ;;
  (checkbox text (_ "Generate key and sign request") name "generate_key")
  (button (_ "Confirm") name "confirm_button" align "left" visibility #f)
  ;;
  (separator colspan 2)
  ;;
  (label text (_ "Export sign request") name "sign_req" align "left")
  (spacer)
  (label text (_ "Destination directory:"))
  (document:id export-request (fileselect title (_"Export sign request")
										  url "/"
										  filter "*.csr"
										  hints "existing_file;directory;show_dirs_only"))
  ;;
  (separator colspan 2)
  (spacer colspan 2)
  ;;
  (label text (_ "Import user certificate:"))
  (document:id import-cert (fileselect title (_"Import user certificate")
									   url "/"
									   filter "*.cert *.crt *.pem"
									   hints "existing_file"))
  ;;
  (spacer colspan 2)
  (spacer colspan 2)
  (hbox align "right"
		colspan 2
		(button (_ "OK") name "ok")
		(button (_ "Apply") name "apply")
		(button (_ "Cancel") name "cancel")))

;;;;;;;;;;;;;;;;;;

(document:root
  (when loaded (reset-name)(ui-init))
  (form-bind "ok" "click" ok)
  (form-bind "apply" "click" apply-all)
  (form-bind "cancel" "click" ui-exit)
  (form-bind "generate_key" "change" (lambda() (form-update-visibility "confirm_button" (form-value "generate_key"))))
  (form-bind "confirm_button" "click" (lambda() (begin
												  (ui-update #f)
												  (on-confirm)))))
