(document:surround "/std/frame")

;;; Functions

(define (ui-update-keys)
  (let* ((keys (woo-list "/sslkey/avail_keys"))
		 (first-value (if (null? keys) #f (woo-get-option (car keys) 'name))))
	(form-update-enum "keys" keys)
	(form-update-value "keys" first-value)))

(define (on-change)
  (form-popup "/sslkey/generate" 'name (form-value "keys"))
  (ui-update-keys))

(define (on-new)
  (form-popup "/sslkey/generate")
  (ui-update-keys))

(define (on-delete)
  (woo-write "/sslkey/delete" 'name (form-value "keys"))
  (form-update-visibility "confirm_delete" #f)
  (form-update-value "delete_all" #f)
  (ui-update-keys))

;;; UI
(gridbox
  columns "0;100"
  margin 40

  (listbox name "keys")

  (spacer)
  (hbox align "right"
		(button (_ "New...") name "new_button")
		(button (_ "Change...") name "change_button"))
  (spacer colspan 2)
  (spacer colspan 2)

  (checkbox text (_ "Delete key, certificate and sign request") name "delete_all")
  (button (_ "Confirm") name "confirm_delete" align "left" visibility #f))

;;;;;;;;;;;;;;;;;;
(document:root
  (when loaded (ui-update-keys))
  (form-bind "change_button" "click" on-change)
  (form-bind "new_button" "click" on-new)
  (form-bind "delete_all" "change" (lambda() (form-update-visibility "confirm_delete" (form-value "delete_all"))))
  (form-bind "confirm_delete" "click" on-delete))
