(define document:root (global 'document:root))

;;helper for tab
(define (tab name . args)
  (tab-page name (apply vbox args)))

;;helper for vertical box
(define (vbox . args)
  (apply box orientation 'vertical args))

;;helper for horizontal box
(define (hbox . args)
  (apply box orientation 'horizontal args))

;;; loops and splashes

;;helper for splash
(define (splash-message . arg)
  (let ((arg (if (null? arg) "" (car arg))))
    (simple-notify document:root
                   'action "splash" 'value arg)))

;;helper for release
(define (document:release)
  (define-operation pause)
  (simple-notify document:root 'action "retry")
  (pause (fluid-ref generic-session)))

;;exit current dialog modal loop
(define (document:end . arg)
  (define-operation stop)
  (stop (global 'document:loop) (if (pair? arg) (car arg)))) ;;return unspecified by default

;;; i18n
(define *po-domain* (make-cell (default-po-domain (or (global 'document:url) ""))))
(define *translator-cache* (make-translator-cache (session-language)))

(define (po-domain domain)
  (cell-set! *po-domain* domain))

(define (_ str . domain)
  (let  ((default-domain (cell-ref *po-domain*))
         (domain (if (pair? domain) (car domain) "_")))
    (translate *translator-cache* str domain default-domain)))

;;; woo-catch
(define (woo-catch/message proc)
  (woo-catch
   proc
   (lambda(reason) (document:popup-critical reason 'ok) #f)))
