;special wrappers over two frame buttons
(document:surround "/std/base")

;;; frame page (frame:page)
(define (frame:page . args)
  (let ((page (document:subdocument)))
    (set-global! 'frame:page page)
    (apply page args)
    page))

(define (frame:replace url . args)
  (let ((page (global 'frame:page)))
     (and page
          (begin
            (page namelist '())
            (wizard-unbind-all)
            (wizard-update-activity "next" #t)
            (wizard-update-activity "previous" #t)
            (apply document:replace-in-widget page url args)))))

;;; wizard transitions (frame:next-button frame:back-button frame:end-button)
(define (frame:call-global name . args)
  (let ((p (global name)))
    (and (procedure? p) (apply p args))))

(define (frame:set-next thunk)
  (set-global! 'frame:next-button thunk))
(define (frame:next)
  (frame:call-global 'frame:next-button))

(define (frame:set-back thunk)
  (set-global! 'frame:back-button thunk))
(define (frame:back)
  (frame:call-global 'frame:back-button))

(define (frame:set-end thunk)
  (set-global! 'frame:end-button thunk))
(define (frame:end)
  (frame:call-global 'frame:end-button))

(define (frame:skip)
  (if (eq? (global 'frame:direction) 'back)
      (frame:back)
      (frame:next)))

;;; wizard buttons (frame:wizard)
(define (frame:set-wizard widget)
  (set-global! 'frame:wizard widget)
  widget)

;;; new form API
(define (form-replace url . url-args)
  (apply frame:replace url url-args))

(define (form-popup url . url-args)
  (apply document:popup url url-args))
