;usefull functions to use in widget descriptions

;apply same actions to group of widgets
(define (widgets . items)
  (lambda args
          (map (lambda (item) (apply item args))
	            items)))

;;;;;;;;;;;;;;; tree helpers

(define (row->branch row)
  (car (fold-right (lambda(x y)
               (list (cons x y)))
             '()
             row)))


(define (cond-cddr x)
  (and (pair? x)
       (pair? (cdr x))
       (pair? (cddr x))
       (cddr x)))

(define (join-rows row1 row2) ;expand row2 with row1
  (let loop ((row1 row1)
             (row2 row2))
    (if (equal? (car row1) (car row2))
        (if (pair? (cdr row1))
            (append (list (car row1))
                    (list (loop (cadr row1) (cadr row2)))
                    (or (cond-cddr row2) '()))
            row2)
        (append row1 row2))))

(define (rows->tree-items rows)
  (fold-right  (lambda(x y) 
                 (if (null? y) x (join-rows x y)))
               '()
               (map row->branch rows)))
