(define-module (ui ulogd ajax)
               :use-module (alterator ajax)
               :use-module (alterator woo)
               :export (init))

(define (form-update-enum-set-first name variants)
  (form-update-enum name variants)
  (form-update-value name (woo-get-option (car variants) 'name)))

(define (ui-update)
  (form-update-value-list '("start_date" "end_date" "state_enabled")
                          (woo-read-first "/ulogd"
                                          'iface (form-value "iface"))))

(define (update-services)
  (form-update-enum "services" (woo-list "/ulogd/services"
                                         'iface (form-value "iface")
                                         'start_date (form-value "start_date")
                                         'end_date (form-value "end_date")
                                         'language (form-value "language"))))

(define (on-apply-state-enabled)
  (catch/message
    (lambda()
      (woo-write
        "/ulogd"
        'state_enabled (form-value "state_enabled")))))

(define (init)
  (form-update-enum-set-first "iface" (woo-list "/ulogd/avail_ifaces"))
  (ui-update)
  (form-bind "iface" "change" (lambda() (begin(ui-update)(form-update-enum "services" '()))))
  (form-bind "apply" "click" on-apply-state-enabled)
  (form-bind "show" "click" update-services))

