(define-module (ui updates ajax)
  :use-module (alterator woo)
  :use-module (alterator ajax)
  :export (on-load))

(define (update-mirror)
  (let ((mirror (form-value "mirror")))
    (form-update-visibility '("custom_url") (string=? mirror "custom"))
    (form-update-enum "repolist" (woo-list "/updates/avail_repo" 'mirror mirror 'language (form-value "language")))))

(define (update-mode)
  (let ((is-internet (string=? (or (form-value "mode") "") "internet"))
	(not-none  (not (string=? (or (form-value "mode") "") "none"))))
    (form-update-activity '("mirror"  "custom_url")
			  is-internet)
    (form-update-activity '("repolist" "schedule" "period" "weekday" "monthday" "time")
			  not-none)
    (and not-none (update-period))))

(define (update-period)
  (let ((period (or (form-value "period") "")))
    (form-update-activity '("monthday") (string=? period "monthly"))
    (form-update-activity '("weekday") (string=? period "weekly"))))

(define (ui-commit)
  (catch/message
    (lambda()
      (apply woo-write
	     "/updates"
	     'language (form-value "language")
	     (form-value-list)))))

(define (ui-init)
  (let ((data (woo-read-first "/updates" 'language (form-value "language"))))
    (form-update-enum "mirror" (woo-list "/updates/avail_mirror" 'language (form-value "language")))
    (form-update-enum "weekday" (woo-list "/updates/avail_weekday" 'language (form-value "language")))
    (form-update-value-list '("mode" "mirror" "custom_url" "period" "weekday" "monthday" "time") data)
    (update-period)
    (update-mirror)
    (update-mode)
    (form-update-value-list '("repolist") data)))

(define (on-load)
    (ui-init)
    (form-bind "mirror" "change" update-mirror)
    (form-bind "mode" "change" update-mode)
    (form-bind "period" "change" update-period)
    (form-bind "apply" "click" ui-commit)
    (form-bind "reset" "click" ui-init))
