(define-module (ui vsftpd ajax)
    :use-module (srfi srfi-1)
    :use-module (alterator ajax)
    :use-module (alterator effect)
    :use-module (alterator woo)
    :export (init))

(define (ui-users-list)
  (form-update-enum "user" (woo-call "/vsftpd/list_user" 'language (form-value "language")))
  (form-update-enum "new_user" (woo-call "/vsftpd/list_avail_user" 'language (form-value "language"))))

(define (ui-users-new)
  (catch/message
    (lambda()
      (let ((new_user (form-value "new_user")))
        (and (string? new_user)
             (begin
               (woo-call "/vsftpd/add_user" 'new_user new_user 'language (form-value "language"))
               (ui-users-list)))))))

(define (ui-users-write)
  (catch/message
    (lambda()
      (let ((user (form-value "user"))
	    (action (form-value "user_action")))
      (and (string? user)
	   (string? action)
	   (begin (woo-call (string-append "/vsftpd/" action) 'user user)
               (ui-users-list)))))))

(define *parameters* '("service_state"
		       "anon_state"
		       "write_state"
		       "local_state"
		       "local_detailed"
		       "anon_mkdir"
		       "anon_upload"
		       "anon_upload_dir"
		       "anon_other"))

(define (ui-read)
  (catch/message
    (lambda()
      (form-update-value-list *parameters* (woo-call "/vsftpd/read_settings"))
      (update-effect))))

(define (ui-write)
  (catch/message
    (lambda()
      ;;note: (form-value-list) filters available paremeters, but checkbox values 
      ;; absent in html request when widget was not selected
      (apply woo-call "/vsftpd/write_settings"
	     (fold (lambda(x rest)
		     (cons* (string->symbol x) (form-value x) rest))
		   '()
		   *parameters*))
      (ui-read))))

(define (init)
  ;; effects
  (effect-disable "anon_upload" "write_state" #f)
  (effect-disable "anon_upload_dir" "write_state" #f)
  (effect-disable "anon_mkdir" "write_state" #f)
  (effect-disable "anon_other" "write_state" #f)

  (effect-disable "anon_mkdir" "anon_state" #f)
  (effect-disable "anon_upload" "anon_state" #f)
  (effect-disable "anon_other" "anon_state" #f)

  (effect-disable "anon_upload_dir" "anon_upload" #f)

  (effect-disable "anon_state" "service_state" #f)
  (effect-disable "anon_mkdir" "service_state" #f)
  (effect-disable "anon_upload" "service_state" #f)
  (effect-disable "anon_other" "service_state" #f)
  (effect-disable "write_state" "service_state" #f)
  (effect-disable "local_state" "service_state" #f)
  (effect-disable "local_detailed" "service_state" #f)
  (init-effect)

  ;; lists
  (form-update-enum "user_action" (woo-call "/vsftpd/list_action" 'language (form-value "language")))
  (ui-users-list)
  (ui-read)

  ;; buttons
  (form-bind "new_user_button" "click" ui-users-new)
  (form-bind "write_user_button" "click" ui-users-write)
  (form-bind "apply" "click" ui-write)
  (form-bind "reset" "click" ui-read))
