(define-module (ui xinetd ajax)
    :use-module (alterator ajax)
    :use-module (alterator woo)
    :use-module (alterator card-index)
    :export (init))

(define (ui-enable)
   (form-update-activity
     '("user" "group" "server" "server_args" "rlimit_as"
       "instances" "per_source" "only_from" "bind")
      (form-value "state")))

(define (ui-read)
  (f-update-ci-list "name" "/xinetd")
  (let ((name (f-get-ci-value "name") ))

    (f-reset "/xinetd" 'name name)

    (form-update-visibility '("state" "rlimit_as" "bind")
      (not (string=? name "__common_settings__")))

    (form-update-visibility '("user" "group" "server" "server_args")
      (not (or (form-value "type") (string=? name "__common_settings__"))))

    (form-update-visibility '("internal_label")  (form-value "type"))

    (form-update-activity
      '("user" "group" "server" "server_args" "rlimit_as"
        "instances" "per_source" "only_from" "bind")
        (form-value "state"))

    (form-update-value "changed" #f)
    (form-update-value "common" (string=? name "__common_settings__"))
  ))

(define (ui-write)
 (f-submit "/xinetd" 'name (f-get-ci-value "name"))
 (ui-read))

(define (init)
  (ui-read)
  (form-bind "name"  "change" ui-read)
  (form-bind "apply" "click"  ui-write)
  (form-bind "reset" "click"  ui-read)
  (form-bind "state" "change" ui-enable)  )


