(document:surround "/std/frame")

; note: label - for html, with +/- prefix
; here we use label2

;; UI

(checkbox value #f visibility #f name "type")
(checkbox value #t visibility #f name "common")

(checkbox value #f visibility #f name "changed")
(edit     value "" visibility #f name "old-name")
(edit     value "" visibility #f name "label2")

(splitbox columns "30;70"

  (listbox name "name"
           header  (vector (_ "Services"))
           row '#((label2 . pic)) )

  (groupbox title ""
   (label name "label")
   (textbox "" alterability #f name "description")

   (gridbox columns "0;100"

    (spacer)
    (checkbox (_ "Enable service") name "state" (when changed (form-update-value "changed" #t)))

    (label text (_ "User:") align "right" name "user")
    (edit value "" name "user" (when changed (form-update-value "changed" #t)))

    (label text (_ "Group:") align "right" name "group")
    (edit value "" name "group" (when changed (form-update-value "changed" #t)))

    (label text (_ "Server:") align "right" name "server")
    (edit value "" name "server" (when changed (form-update-value "changed" #t)))

    (label text (_ "Server args:") align "right" name "server_args")
    (edit value "" name "server_args" (when changed (form-update-value "changed" #t)))

    (label text (_ "Rlimit as:") align "right" name "rlimit_as")
    (edit value "" name "rlimit_as" (when changed (form-update-value "changed" #t)))

    (label text (_ "Instances:") align "right" name "instances")
    (edit value "" name "instances" (when changed (form-update-value "changed" #t)))

    (label text (_ "Per source:") align "right" name "per_source")
    (edit value "" name "per_source" (when changed (form-update-value "changed" #t)))

    (label text (_ "Only from:") align "right" name "only_from")
    (edit value "" name "only_from" (when changed (form-update-value "changed" #t)))

    (label text (_ "Interface:") align "right" name "bind")
    (edit value "" name "bind" (when changed (form-update-value "changed" #t)))

    (spacer)
    (gridbox columns "0;0;100"
      (button text (_ "Apply") name "apply")
      (button text (_ "Reset") name "reset")
      (spacer) ))))

; functions

(define (ui-read)

  (let* ((listdata (woo-list "/xinetd"))
         (name1 (form-value "name"))
         (name (if (string=? name1 "") 
                  (woo-get-option (cond-car listdata) 'name) name1))
         (readdata (woo-read-first "/xinetd/" 'name name)) )

    (form-update-value "old-name" name)
    (form-update-value "name" name)
    (catch/message ( lambda ()
      (form-update-enum  "name" listdata)
      (form-update-value "name" name)

      (form-update-value-list
        `("description" "label2" "state" "user" "group" "server" "server_args" "rlimit_as"
          "instances" "per_source" "only_from" "bind" "type") readdata)))

    (form-update-value "changed" #f)
    (form-update-value "common" (string=? name "__common_settings__"))

    (form-update-value "label"
      (string-append
      "<b>" (form-value "label2")
      (if (form-value "type") (string-append " (" (_"internal service") ")") "")
      "</b>" ))
     (my-update-effect)
    ))


(define (my-update-effect)
    (form-update-visibility '("state" "rlimit_as" "bind")
      (not (string=? (form-value "name") "__common_settings__")))

    (form-update-visibility '("user" "group" "server" "server_args")
      (not (or (form-value "type") (string=? (form-value "name") "__common_settings__"))))

    (form-update-activity '("user" "group" "server" "server_args" "rlimit_as"
                            "instances" "per_source" "only_from" "bind")
      (form-value "state"))

    (form-update-visibility '("internal_label")
      (form-value "type"))
)

(define (ui-change)
  (and (form-value "changed")
       (eq? 'yes (document:popup-question (_"There are unsaved changes in the service settings. Do you want to apply these changes?") 'yes 'no))
       (let ((name (form-value "name") ))
         (form-update-value "name" (form-value "old-name"))
         (ui-write)
         (form-update-value "name" name) ))
  (ui-read))

(define (ui-write)
  (catch/message ( lambda ()
    (apply woo-write "/xinetd/" (form-value-list)) ))
  (ui-read)
  (form-update-value "changed" #f))

(define (ui-init)
  (ui-read)
  (form-bind "name"  "change" ui-change)
  (form-bind "apply" "click"  ui-write)
  (form-bind "reset" "click"  ui-read)
  (form-bind "state" "change" my-update-effect) )

(document:root (when loaded (ui-init)))

