#!/bin/sh -efu

. install2-sh-functions

# Options for curl
release_file="$(mktemp --quiet --tmpdir release.XXXXX)"
curl_opt_cmn="--connect-timeout 2 \
                 --max-time 2 \
                 --output $release_file \
                 --silent \
                 --write-out %{http_code}"
curl_opt_ftp="$curl_opt_cmn --ftp-pasv"
curl_opt_http="$curl_opt_cmn"

get_comps()
{
    local url=$1
    local ret=-1
    local curl_opt=
    local is_http=$(expr match "$url" '\(http\)')
    local is_ftp=$(expr match "$url" '\(ftp\)')

    [ -z "$url" ] && return $ret
    [ -z "$release_file" ] && return $ret
    [ -x "/usr/bin/curl" ] || return $ret

    if [ -n "$is_ftp}" ]; then
        curl_opt="$curl_opt_ftp"
    elif [ -n "$is_http" ]; then
        curl_opt="$curl_opt_http"
    else
        return $ret
    fi

    ret_code="$(curl $curl_opt --url "$url")"

    if [ -n "$is_ftp" ]; then
        [ $ret_code -eq 226 ] && ret=0
    elif [ -n "$is_http" ]; then
        [ $ret_code -eq 200 ] && ret=0
    fi

    return $ret
}

#create sources.list
case "$METHOD" in
	cdrom|disk|nfs)
		url="file:$image_dir"
		comps="$(find "$image_dir"/ALTLinux \
			    -mindepth 1 -maxdepth 1 -type d -name 'RPMS.*' -printf '%f\n' |
			    sed -e 's/^RPMS\.//' |
			    tr '\n' ' ')"
		;;
    http|ftp)
        url="$image_url"
        if get_comps "$url/ALTLinux/base/release" ; then
            comps="$(cat "$release_file" | sed -n -e '/\/release\./p' | sed -e 's/.*\.//' | tr '\n' ' ')"
        else
            comps="main"
        fi
        ;;
esac

BACKUP_SUFF=".$(rpm -qf "$0").backup"
# Save the original sources.list
mv /etc/apt/sources.list "/etc/apt/sources.list$BACKUP_SUFF"
printf 'rpm %s ALTLinux %s\n' "$url" "${comps% }" >/etc/apt/sources.list

# Save the original apt.conf
mv /etc/apt/apt.conf "/etc/apt/apt.conf$BACKUP_SUFF"

#create special apt.conf
cat >/etc/apt/apt.conf <<__EOF__
Dir::State "$destdir/var/lib/apt/";
Dir::Cache "$destdir/var/cache/apt/";
RPM::RootDir "$destdir";
APT::Install::Virtual "true";
APT::Install::VirtualVersion "true";
Acquire::CDROM::Copy-All "false";
__EOF__

temp_file=/tmp/pkg-groups.tar
if ! [ -f "$temp_file" ] && cp-metadata "$temp_file" ;then
    mkdir -p -- var/lib/install3
    tar -C /var/lib/install3 -xpf "$temp_file"
fi
