#!/bin/sh -efu

. install2-init-functions

cdrom_dir="/media/cdrom"

# clean apt cache
run_chroot apt-get clean

# setup apt sources
sources_list()
{
	local url="$1";shift;
	local comps="$1";shift;

	mkdir -p -- "$destdir/etc/apt/sources.list.d"
	printf 'rpm %s ALTLinux %s\n' "$url" "${comps% }" > "$destdir/etc/apt/sources.list.d/sources.installer.list"
}

# Return the original apt.conf and sources.list back
restore() {
	local orig=".$(rpm -qf "$0").backup"
	[ -f "/etc/apt/apt.conf$orig" ] && mv "/etc/apt/apt.conf$orig" /etc/apt/apt.conf
	[ -f "/etc/apt/sources.list$orig" ] && mv  "/etc/apt/sources.list$orig" /etc/apt/sources.list
}

sources_cdrom()
{
    run_chroot mount "$cdrom_dir"
    run_chroot apt-cdrom --cdrom "$cdrom_dir" --no-mount -o dir::etc=/etc/apt/sources.list.d add
    run_chroot umount "$cdrom_dir"
}

#always put cdrom into fstab and make /media/cdrom
CDROMDEV=${CDROMDEV:-"/dev/sr0"}
printf '%s\t%s\t%s\t%s\t%s\n' "$CDROMDEV" "$cdrom_dir" "udf,iso9660" "ro,noauto,user,utf8" "0 0" >> "$destdir/etc/fstab"
mkdir -p -- "$destdir/$cdrom_dir"

# Options for curl
release_file="$(mktemp --quiet --tmpdir release.XXXXX)"
curl_opt_cmn="--connect-timeout 2 \
                 --max-time 2 \
                 --output $release_file \
                 --silent \
                 --write-out %{http_code}"
curl_opt_ftp="$curl_opt_cmn --ftp-pasv"
curl_opt_http="$curl_opt_cmn"

get_comps()
{
    local url=$1
    local ret=-1
    local curl_opt=
    local is_http=$(expr match "$url" '\(http\)')
    local is_ftp=$(expr match "$url" '\(ftp\)')

    [ -z "$url" ] && return $ret
    [ -z "$release_file" ] && return $ret
    [ -x "/usr/bin/curl" ] || return $ret

    if [ -n "$is_ftp}" ]; then
        curl_opt="$curl_opt_ftp"
    elif [ -n "$is_http" ]; then
        curl_opt="$curl_opt_http"
    else
        return $ret
    fi

    ret_code="$(curl $curl_opt --url "$url")"

    if [ -n "$is_ftp" ]; then
        [ $ret_code -eq 226 ] && ret=0
    elif [ -n "$is_http" ]; then
        [ $ret_code -eq 200 ] && ret=0
    fi

    return $ret
}

case "$METHOD" in
	cdrom)
		sources_cdrom
		;;
	http|ftp)
        comps="base"
        if get_comps "$image_url/ALTLinux/base/release" ; then
            comps="$(cat "$release_file" | sed -n -e '/\/release\./p' | sed -e 's/.*\.//' | tr '\n' ' ')"
        fi
		sources_list "$image_url" "$comps"
		;;
	disk|nfs)
		#skip removable devices
		;;
esac

# Restore the original apt.conf and sources.list
restore
