"""distutils.command.bdist_rpm

Implements the Distutils 'bdist_rpm' command (create RPM source and binary
distributions)."""

# This module should be kept compatible with Python 1.5.2.

__revision__ = "$Id: bdist_altrpm.py 29 2006-06-10 12:08:45Z ns $"

import sys, os, string
import glob
from types import *
from distutils.core import Command
from distutils.debug import DEBUG
from distutils.util import get_platform
from distutils.file_util import write_file
from distutils.errors import *
from distutils import log
from bdist_rpm import bdist_rpm

class bdist_altrpm (bdist_rpm):

    description = "create an ALTLinux RPM distribution"
    user_options = bdist_rpm.user_options[:] + [
        ('read-changelog=', None,
         "Old spec-file or another file content changelog"),
        ('daedalus', None,
         "Conditional macros to rebuild with experimental option for daedalus included"),
    ]

    def initialize_options (self):
        self.read_changelog = None
        self.daedalus = None
        bdist_rpm.initialize_options(self)

    def finalize_package_data (self):
        if self.read_changelog :
            f = open(self.read_changelog)
            for item in f.xreadlines() :
                if item.find("%changelog") == 0 :
                    self.changelog = "".join(f.xreadlines())
                    break
            f.close()                
        self.ensure_string('group', "Development/Python")
        self.ensure_string('release', "alt1")
        bdist_rpm.finalize_package_data(self)

    def _make_spec_file(self):
        """Generate the text of an RPM spec file and return it as a
        list of strings (one per line).
        """
        # definitions and headers
        spec_file = [
            '%define version ' + self.distribution.get_version(),
            '%define release ' + self.release,
            '%setup_python_module ' + self.distribution.get_name(),
            ]
            
        if self.daedalus :
             spec_file.extend([
                '%def_with daedalus',
                '%if_with daedalus',
                '%%define release %s.d' % self.release,
                '%endif',
                '',
                ])            
            
        spec_file.extend([     
            '',
            'Summary: ' + self.distribution.get_description(),
            ])

        # put locale summaries into spec file
        # XXX not supported for now (hard to put a dictionary
        # in a config file -- arg!)
        #for locale in self.summaries.keys():
        #    spec_file.append('Summary(%s): %s' % (locale,
        #                                          self.summaries[locale]))

        spec_file.extend([
            'Name: %packagename',
            'Version: %version',
            'Release: %release',])

        # XXX yuck! this filename is available from the "sdist" command,
        # but only after it has run: and we create the spec file before
        # running "sdist", in case of --spec-only.
        if self.use_bzip2:
            spec_file.append('Source0: %modulename-%version.tar.bz2')
        else:
            spec_file.append('Source0: %modulename-%version.tar.gz')

        spec_file.extend([
            'License: ' + self.distribution.get_license(),
            'Group: ' + self.group, ])

        if self.daedalus :
            spec_file.extend([
                #'%if_with daedalus',
                # 'AutoReqProv: yes, python',
                #'%endif' 
                ])

        # noarch if no extension modules
        if not self.distribution.has_ext_modules():
            spec_file.append('BuildArchitectures: noarch')

        for field in ('Vendor',
                      'Provides',
                      'Requires',
                      'Conflicts',
                      'Obsoletes',
                      ):
            val = getattr(self, string.lower(field))
            if type(val) is ListType:
                spec_file.append('%s: %s' % (field, string.join(val)))
            elif val is not None:
                spec_file.append('%s: %s' % (field, val))


        if self.distribution.get_url() != 'UNKNOWN':
            spec_file.append('URL: ' + self.distribution.get_url())

        if self.distribution_name:
            spec_file.append('Distribution: ' + self.distribution_name)

        if self.build_requires:
            spec_file.append('BuildRequires: ' +
                             string.join(self.build_requires))

        if self.icon:
            spec_file.append('Icon: ' + os.path.basename(self.icon))

        spec_file.extend([
            '',
            '%description',
            self.distribution.get_long_description()
            ])

        # put locale descriptions into spec file
        # XXX again, suppressed because config file syntax doesn't
        # easily support this ;-(
        #for locale in self.descriptions.keys():
        #    spec_file.extend([
        #        '',
        #        '%description -l ' + locale,
        #        self.descriptions[locale],
        #        ])

        # rpm scripts
        # figure out default build script
        def_build = "%__python setup.py build" 
        if self.use_rpm_opt_flags:
            def_build = 'env CFLAGS="$RPM_OPT_FLAGS" ' + def_build

        # insert contents of files

        # XXX this is kind of misleading: user-supplied options are files
        # that we open and interpolate into the spec file, but the defaults
        # are just text that we drop in as-is.  Hmmm.

        script_options = [
            ('prep', 'prep_script', "%setup  -q -n %modulename-%version"),
            ('build', 'build_script', def_build),
            ('install', 'install_script',
             ("%__python setup.py install "
              "--root=%buildroot "
              "--optimize=2 "
              "--record=INSTALLED_FILES") ),
            ('clean', 'clean_script', None),
            ('verifyscript', 'verify_script', None),
            ('pre', 'pre_install', None),
            ('post', 'post_install', None),
            ('preun', 'pre_uninstall', None),
            ('postun', 'post_uninstall', None),
        ]

        for (rpm_opt, attr, default) in script_options:
            # Insert contents of file referred to, if no file is referred to
            # use 'default' as contents of script
            val = getattr(self, attr)
            if val or default:
                spec_file.extend([
                    '',
                    '%' + rpm_opt,])
                if val:
                    spec_file.extend(string.split(open(val, 'r').read(), '\n'))
                else:
                    spec_file.append(default)


        # files section
        spec_file.extend([
            '',
            '%files -f INSTALLED_FILES',
            '%defattr(-,root,root)',
            ])

        if self.doc_files:
            spec_file.append('%doc ' + string.join(self.doc_files))

        if self.changelog:
            spec_file.extend([
                '',
                '%changelog',])
            spec_file.extend(self.changelog)

        return spec_file

    # _make_spec_file ()

# class bdist_altrpm
