<?xml version='1.0' encoding="windows-1251"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:exsl="http://exslt.org/common" 
                extension-element-prefixes="exsl"
                version='1.0'>

<!-- $Id$ -->

<!-- 
     Stylesheet for strip locales from gconf schema files.
     Author: Vitaly Ostanin <vyt@altlinux.ru>
     -->

<xsl:output method="xml" encoding="utf8" indent="yes"/>

<xsl:param name="output.locales.xml">battstat.schemas.locales.xml</xsl:param>
  
<!--   ,     -->
<xsl:template match="@*|comment()|processing-instruction()">
  <xsl:copy/>
</xsl:template>

  <!--        -->
  <xsl:template match="*">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="schema">
    <xsl:copy>
      <xsl:apply-templates select="@*|key|applyto|owner|type|default|locale[@name='C']"/>
      <xi:include xmlns:xi="http://www.w3.org/2003/XInclude"
        href="{$output.locales.xml}"
        xpointer="xpointer(/alt-gconf-schema-file-locales/schemalist/schema[@key='{key}']/*)"
        parse="xml">
        <xi:fallback/>
      </xi:include>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="/">
    <exsl:document href="{$output.locales.xml}" method="xml" encoding="utf8" indent="yes">
      <alt-gconf-schema-file-locales>
        <xsl:apply-templates mode="locales"/>
      </alt-gconf-schema-file-locales>
    </exsl:document>
    <xsl:apply-templates/>
  </xsl:template>

  <!--   ,     -->
  <xsl:template match="@*|comment()|processing-instruction()" mode="locales">
    <xsl:copy/>
  </xsl:template>

  <!--        -->
  <xsl:template match="*" mode="locales">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()" mode="locales"/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="gconfschemafile|key|applyto|owner|type|default" mode="locales">
    <xsl:apply-templates mode="locales"/>
  </xsl:template>

  <xsl:template match="schema" mode="locales">
    <xsl:copy>
      <xsl:attribute name="key">
        <xsl:value-of select="key"/>
      </xsl:attribute>
      <xsl:apply-templates select="@*|locale[not(@name='C')]" mode="locales"/>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
