.EXPORT_ALL_VARIABLES:
.DEFAULT_GOAL := all

include /usr/share/make-initrd/config.mk
include /usr/share/make-initrd/rules.mk
include /usr/share/make-initrd/guess.mk

ifneq "$(strip $(INITRD_CONFIG))" ''

# Load requested features
ifneq "$(strip $(FEATURES))" ''
include $(call require,$(FEATURES))
endif # FEATURES

else # !INITRD_CONFIG

public_goals  = all guess-config guess-modules bug-report
private_goals = $(filter-out $(public_goals),$(MAKECMDGOALS))

ifneq "$(private_goals)" ''
    $(error You MUST NOT call private goals directly: $(private_goals))
endif
endif # INITRD_CONFIG

all: check-for-root
	@rc=0; \
	for c in $(INITRD_CONFIG_LIST); do \
		echo "Config file: $$c"; \
		wsuffix="$${c##*/}"; \
		wsuffix="$${wsuffix%.mk}"; \
		export WORKDIR_SUFFIX="$$wsuffix"; \
		export INITRD_CONFIG="$$c"; \
		$(TOOLSDIR)/run-make $(MAKE) $(MFLAGS) -f /usr/share/make-initrd/make-initrd.mk guess    || { rc=1; break; }; \
		export IGNORE_DEPMOD=1; \
		$(TOOLSDIR)/run-make $(MAKE) $(MFLAGS) -f /usr/share/make-initrd/make-initrd.mk genimage || { rc=1; break; }; \
	done; \
	rm -f -- $(TEMPDIR)/images; \
	exit $$rc

guess-config: check-for-root guess
	@cat $(GUESSDIR)/guessed.mk
	$Qrm -rf -- "$(GUESSDIR)"
	$Qrmdir -- "$(WORKDIR)"

guess-modules: check-for-root guess
	@for f in $(GUESSDIR)/guess:modules* $(GUESSDIR)/guess:modalias*; do \
		[ ! -s "$$f" ] || cat "$$f"; \
	done | \
	   xargs -r depinfo \
	      --set-version="$(KERNEL)" \
	      --no-prefix \
	      --no-firmware \
	      --no-builtin \
	      2>/dev/null | \
	   sort -u
	$Qrm -rf -- "$(GUESSDIR)"
	$Qrmdir -- "$(WORKDIR)"

bug-report: check-for-root
	@mkdir -m 755 -p -- $(REPORTDIR)
	@$(TOOLSDIR)/bug-report
	$Qrm -rf -- "$(REPORTDIR)"
	$Qrmdir -- "$(WORKDIR)"
