#
# We do contents related stuff
#
#   contents --list type       return a list of files (type = xml or html)
#            --list-ref type   same, but for reference section
#
#            --gen-contents    generate contents.xml
#
#            --params-for name return the preceding and next pages
#                              for the file called <name>

require 'getoptlong'

opts = GetoptLong.new(
  [ "--list",         GetoptLong::REQUIRED_ARGUMENT ],
  [ "--list-ref",     GetoptLong::REQUIRED_ARGUMENT ],
  [ "--params-for",   GetoptLong::REQUIRED_ARGUMENT ],
  [ "--gen-contents", GetoptLong::NO_ARGUMENT ]
)                      
       
BUILTIN_NAME = "builtins"
                
CONTENTS = 
  [
  "foreword",
  "preface",
  "roadmap",
  "intro",
  "tut_classes",
  "tut_containers",
  "tut_stdtypes",
  "tut_methods",
  "tut_expressions",
  "tut_exceptions",
  "tut_modules",
  "tut_io",
  "tut_threads",
  "trouble",
  "rubyworld",
  "web",
  "ext_tk",
  "win32",
  "ext_ruby",
  "language",
  "classes",
  "taint",
  "ospace",
  BUILTIN_NAME,
 "lib_standard",
  "lib_patterns",
  "lib_network",
  "lib_windows",
  "rdtool",
  "irb",
  "support",
]

BUILTINS =
  [
    "ref_c_array",
    "ref_c_bignum",
    "ref_c_binding",
    "ref_c_class",
    "ref_c_continuation",
    "ref_c_dir",
    "ref_c_exception",
    "ref_c_falseclass",
    "ref_c_file",
    "ref_c_file__stat",
    "ref_c_fixnum",
    "ref_c_float",
    "ref_c_hash",
    "ref_c_integer",
    "ref_c_io",
    "ref_c_matchdata",
    "ref_c_method",
    "ref_c_module",
    "ref_c_nilclass",
    "ref_c_numeric",
    "ref_c_object",
    "ref_c_proc",
    "ref_c_range",
    "ref_c_regexp",
    "ref_c_string",
    "ref_c_struct",
    "ref_c_struct__tms",
    "ref_c_symbol",
    "ref_c_thread",
    "ref_c_threadgroup",
    "ref_c_time",
    "ref_c_trueclass",
    "ref_m_comparable",
    "ref_m_enumerable",
    "ref_m_errno",
    "ref_m_filetest",
    "ref_m_gc",
    "ref_m_kernel",
    "ref_m_marshal",
    "ref_m_math",
    "ref_m_objectspace",
    "ref_m_process",
  ]


def doList(type, from)
  case type
  when "xml"
    prefix = "xml/"
    suffix = ".xml"
  when "html"
    prefix = "html/"
    suffix = ".html"
  else
    raise "type must be 'xml' or 'html'"
  end

  from.each do |name|
    puts prefix + name + suffix unless name == BUILTIN_NAME
  end
end

def doGenContents
  puts "<ppdoc><contents>"
  CONTENTS.each do |name|
    title = ''
    if name == BUILTIN_NAME
      title = "Built-in Classes and Methods"
    else
      xmlFile = "xml/#{name}.xml"
      File.open(xmlFile) do |f|
        buff = f.read(2000)
        raise "Can't find name in #{name}" unless buff =~ /name="(.*?)"/m
        title = $1
      end
    end
    puts %{<tocentry file="#{name}.html">#{title}</tocentry>}
  end
  puts "</contents></ppdoc>"
end

def doParamsFor(name)
  name = File.basename(name, ".html")
  if name == "contents"
    puts ""
    exit
  end
  for which in [CONTENTS, BUILTINS] 
    index = which.index(name)
    if index
      res = "$content=" + (which == CONTENTS ? "index" : "builtins")
      if index > 0
        res += %/ $prev=#{which[index-1]}/
      end
      index += 1
      if index < which.size
        res += %/ $next=#{which[index]}/
      end
      puts res
      exit
    end
  end
  raise "Don't know anything about #{name}"
end


#################################################################33
#
# Main program
#

opts.each do |opt, arg|

  case opt
  when "--list"
    doList(arg, CONTENTS)
  when "--list-ref"
    doList(arg, BUILTINS)
  when "--gen-contents"
    doGenContents
  when "--params-for"
    doParamsFor(arg)
  else
    raise "Unknown option: #{opt}"
  end
end
