<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

<xsl:output method="html" encoding="iso-8859-1"/>
<xsl:param name="content">contents</xsl:param>
<xsl:param name="next"></xsl:param>
<xsl:param name="prev"></xsl:param>

<xsl:template match="/">
 <html>
 <head>
   <title>Ruby Class and Library Reference</title>
   <STYLE TYPE="text/css">
   <xsl:text disable-output-escaping="yes">&lt;!--</xsl:text>
       BODY    { margin-left: .75in;
                 margin-right: .5in;
                 font-family: helvetica, arial, sans-serif;
               }
       H1      { color: #000080;
                 font-family: helvetica, arial, sans-serif;
                 font-size: 32pt;
                 margin-left: 0in
               }
       H2      { color: #000080;  font: bold x-large helvetica, sans-serif;
                 margin-left: 0in }
       H3      { color: #000080;  font: bold   large helvetica, sans-serif; }
       H4      { color: #000080;  font: italic large helvetica, sans-serif; }
       .ruby   { background: #fff0f0 }
       .header { color: white }
       .subheader { color: #ffdddd }
       span.sans { font-family: helvetica, arial, sans-serif }
       -->
   </STYLE>
 </head>
 <body bgcolor="white">
 <table width="100%" bgcolor="#902020" cellpadding="20">
   <tr>
     <td width="40%">
       <h1 class="header">Programming Ruby</h1>
       <h3 class="subheader">The Pragmatic Programmer's Guide</h3>
     </td>
     <td width="45%" bgcolor="white"><img src="dot.gif"/></td>
     <td width="25%" align="right" valign="middle">
       <a class="subheader" href="{$content}.html">Contents ^</a><br/>
       <a class="subheader" href="{$next}.html">Next &gt;</a><br/>
       <a class="subheader" href="{$prev}.html">Previous &lt;</a>
     </td>
   </tr>
 </table>
   This page lists the built-in Ruby classes and modules, and the
   methods they contain. Click on a class, module, or method name for
   a detailed description.
   <hr></hr>
   <table>
     <tr>
       <td valign="center" colspan="2"  bgcolor="990066">
         <font color="white" size="6">
           classes
         </font>
      </td>
     </tr>
     <tr><td><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></td></tr>
     <xsl:apply-templates select="index/module[@type='class']"/>

     <tr><td><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></td></tr>
     <tr><td><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></td></tr>
     <tr>
       <td valign="center" colspan="2"  bgcolor="990066">
         <font color="white" size="6">
           modules
         </font>
      </td>
     </tr>
     <tr><td><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></td></tr>
     <xsl:apply-templates select="index/module[@type='module']"/>
   </table>
   <p></p>
   <hr></hr>
   <font size="-3">
      Copyright
      <xsl:text disable-output-escaping="yes">&amp;#169;</xsl:text>
      2000 Addison Wesley Longman, Inc. All Rights Reserved
   </font>
 </body>
 </html>
</xsl:template>

<xsl:template match="module">
  <tr>
    <xsl:if test="position() mod 2 = 0">
       <xsl:attribute name="bgcolor">#ffcccc</xsl:attribute>
    </xsl:if>
    <td valign="top">
    <a href="{./@file}.html">
      <font size="+1"><b><xsl:value-of select="./@name"/></b></font>
    </a>
  </td>
  <td>
    
    <xsl:apply-templates/>
  </td>
  </tr>
</xsl:template>

<!-- :: removed - it -->
<xsl:template match="meth[@type='class']">
    <a href="{../@file}.html#{ancestor::module@name}.{./@ref}"><xsl:value-of select="./@name"/></a>
</xsl:template>
<xsl:template match="meth[@type='instance']">
    <a href="{../@file}.html#{ancestor::module@name}.{./@ref}"><i><xsl:value-of select="./@name"/></i></a>
</xsl:template>


</xsl:stylesheet>
