<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0"
                extension-element-prefixes="xt">

<xsl:output method="html" encoding="iso-8859-1"/>
<xsl:param name="content"></xsl:param>
<xsl:param name="next"></xsl:param>
<xsl:param name="prev"></xsl:param>

<xsl:template match="/">
 <html>
 <head>
   <title>Programming Ruby: The Pragmatic Programmer's Guide</title>
   <link rel="StyleSheet" href="pr_style.css" type="text/css" media="screen"/>
 </head>
 <body bgcolor="white">
    <table bgcolor="#c09090" cellpadding="3" border="0" cellspacing="0" width="100%">
      <tr>
      <td colspan="3">
      <table bgcolor="#701a1a" cellpadding="20" width="100%">
       <tr><td width="6in">
         <h1 class="header">Programming Ruby</h1>
         <h3 class="subheader">The Pragmatic Programmer's Guide</h3>
       </td></tr></table>
     </td>
   </tr>
   <tr>
     <td width="33%" align="left">
       <xsl:if test="$prev">
         <a class="subheader" href="{$prev}.html">Previous &lt;</a>
       </xsl:if>
     </td>
     <td width="33%" align="center" valign="middle">
       <xsl:if test="$content">
         <a class="subheader" href="{$content}.html">Contents ^</a><br/>
       </xsl:if>
     </td>
     <td width="33%" align="right" >
       <xsl:if test="$next">
         <a class="subheader" href="{$next}.html">Next &gt;</a><br/>
       </xsl:if>
     </td>
   </tr>
 </table>
   <xsl:apply-templates/>
   <p/>
   <hr/>
   <table bgcolor="#a03030" cellpadding="10" border="0" cellspacing="0">
     <tr>
       <td width="33%" align="left">
         <xsl:if test="$prev">
           <a class="subheader" href="{$prev}.html">Previous &lt;</a>
         </xsl:if>
       </td>
       <td width="33%" align="center" valign="middle">
         <xsl:if test="$content">
           <a class="subheader" href="{$content}.html">Contents ^</a><br/>
         </xsl:if>
       </td>
       <td width="33%" align="right" >
         <xsl:if test="$next">
           <a class="subheader" href="{$next}.html">Next &gt;</a><br/>
         </xsl:if>
       </td>
     </tr>
   </table>
   <p/>
   <font size="-1">Extracted from the book "Programming Ruby -
     The Pragmatic Programmer's Guide"</font><br/>
   <font size="-3">
      Copyright
      <xsl:text disable-output-escaping="yes">&amp;#169;</xsl:text>
      2000 Addison Wesley Longman, Inc. Released under the terms of the
      <a href="http://www.opencontent.org/openpub/">Open Publication License</a> V1.0.
        <br/>
      This reference is available for
        <a href="http://www.pragmaticprogrammer.com/ruby/downloads/book.html">download</a>.
   </font>
 </body>
 </html>
</xsl:template>

<xsl:template match="ppdoc">
  <xsl:apply-templates/>
</xsl:template>

<!-- Table of contents -->

  <xsl:template match="contents">
    <h1>Table of Contents</h1>
    <blockquote><blockquote>
      <table  width="558" height="730" background="fadedcover.gif">
        <tr><td>
          <xsl:apply-templates/>
        </td></tr>
      </table>
    </blockquote></blockquote>
  </xsl:template>

<xsl:template match="tocentry">
  <a href="{./@file}"><xsl:apply-templates/></a><br/>
</xsl:template>



<xsl:template match="copyright">
  <xsl:text disable-output-escaping="yes">&lt;!--</xsl:text>
  <xsl:apply-templates/>
  <xsl:text disable-output-escaping="yes">--&gt;</xsl:text>
</xsl:template>

<xsl:template match="p">
  <P/>
</xsl:template>

<xsl:template match="nbsp">
  <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
</xsl:template>

<!-- Constants in module definitions -->
<xsl:template match="constants">
  <table border="0" width="100%" cellpadding="10">
  <tr>
    <td valign="center" colspan="3"  bgcolor="990066">
       <font color="white" size="6">
         constants
       </font>
    </td>
  </tr>
  </table>
  <table border="2" cellpadding="5">
    <xsl:apply-templates/>
  </table>
  <p/>
</xsl:template>

<xsl:template match="noTableConstants">
  <table border="0" width="100%" cellpadding="10">
  <tr>
    <td valign="center" colspan="3"  bgcolor="990066">
       <font color="white" size="6">
         constants
       </font>
    </td>
  </tr>
  </table>
  <p/>
    <xsl:apply-templates/>
  <p/>
</xsl:template>

<xsl:template match="constant">
  <tr>
    <xsl:apply-templates/>
  </tr>
</xsl:template>

<xsl:template match="constname">
  <td>
    <a name="{ancestor::class@name}.{.}"><code><xsl:apply-templates/></code></a>
  </td>
</xsl:template>

<xsl:template match="constval">
  <td>
    <xsl:apply-templates/>
  </td>
</xsl:template>

<xsl:template match="constdesc">
  <td>
    <xsl:apply-templates/>
  </td>
</xsl:template>

<xsl:template match="library">
  <table border="0" width="100%" bgcolor="660066" cellpadding="10">
    <tr>
      <td valign="center">
        <font color="white" size="7">
          Library: <xsl:apply-templates select="attribute::name"/>
        </font>
      </td>
    </tr>
  </table>
  <p/>
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="class">
  <table>
    <tr><td height="20"><img src="dot.gif" width="1" height="20"/></td></tr>
  </table>
  <table border="0" width="100%" bgcolor="660066" cellpadding="10">
  <tr>
    <td valign="center">
       <font color="white" size="7">
         <xsl:value-of select="./@type"/>
         <xsl:text> </xsl:text>
         <xsl:apply-templates select="attribute::name"/>
         </font>
    </td>
    <xsl:if test="./@super">
    <td><table border="0">
          <tr>
            <td>
              <font color="white">
                Parent:
              </font>
            </td>
            <td>
              <font color="white">
               <xsl:apply-templates select="attribute::super"/>
              </font>
            </td>
          </tr>
          <tr>
            <td>
              <font color="white">
                Version:
              </font>
            </td>
            <td>
              <font color="white">
               1.6
              </font>
            </td>
          </tr>
        </table>
    </td>
    </xsl:if>
    <xsl:if test="./relieson">
    <td><table border="0">
          <tr>
            <td>
              <font color="white">
                Relies on:
              </font>
            </td>
            <td>
              <font color="white">
               <xsl:value-of select="./relieson"/>
              </font>
            </td>
          </tr>
        </table>
    </td>
    </xsl:if>
  </tr>
  </table>
  <p/>
  <H3>Index:</H3>
  <xsl:for-each select="methods[@type='class']//method">
     <a href="#{ancestor::class@name}.{./@ref}">
       <!-- :: removed - buggers IE-->
       <xsl:value-of select="attribute::name"/>
     </a>
     <xsl:text> <!-- this seems to force a NL in the HTML output -->
     </xsl:text>
  </xsl:for-each>
  <xsl:for-each select="methods[@type='instance']//method">
     <i><a href="#{ancestor::class@name}.{./@ref}">
     <xsl:value-of select="attribute::name"/></a></i>
     <xsl:text> </xsl:text>
  </xsl:for-each>
  <xsl:for-each select="methods[@type='private']//method">
     <i><a href="#{ancestor::class@name}.{./@ref}"><xsl:value-of select="attribute::name"/></a></i>
     <xsl:text> </xsl:text>
  </xsl:for-each>
  <p/><hr/>
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="relieson">
</xsl:template>

<xsl:template match="methods">
  <xsl:apply-templates select="./figure"/>
  <table border="0" width="100%" cellpadding="10">
  <tr>
    <td valign="center" colspan="2"  bgcolor="990066">
       <font color="white" size="6">
         <xsl:apply-templates select="attribute::type"/> methods
       </font>
    </td>
  </tr>
  <xsl:apply-templates select="./method"/>
  </table>
</xsl:template>

<xsl:template match="mixins">
  <table border="0" width="100%" cellpadding="10">
  <tr>
    <td valign="center" colspan="2"  bgcolor="990066">
       <font color="white" size="6">
         mixins
       </font>
    </td>
  </tr>
    <xsl:apply-templates/>
  </table>
</xsl:template>

<xsl:template match="mixin">
  <tr>
    <td>
        <xsl:apply-templates select="attribute::name"/>:
    </td>
    <td>
        <xsl:apply-templates/>
    </td>
  </tr>
</xsl:template>

<xsl:template match="method">
  <tr>
    <td valign="center" bgcolor="#ff9999">
       <font size="4">
          <b><a name="{ancestor::class/@name}.{./@ref}">
          <xsl:apply-templates select="attribute::name"/>
          </a></b>
       </font>
    </td>
    <td bgcolor="#ffaaaa">
       <xsl:apply-templates select="./callseq"/>
    </td>
  </tr>
    <td>
    </td>
    <td>
      <xsl:apply-templates select="./desc"/>
    </td>
</xsl:template>



<!-- ignore <p> between methods -->
<xsl:template match="methods/p">
</xsl:template>

<!-- convet an alltt within a codefragment into a singlecelled table -->
<xsl:template match="codefragment/alltt">
  <table class="codebox" cellspacing="0" border="0" cellpadding="3" width="400">
    <tr><td><pre><xsl:apply-templates/></pre></td></tr>
  </table>
</xsl:template>

<xsl:template match="verbatim">
  <table class="codebox" cellspacing="0" border="0" cellpadding="3" width="500">
    <tr><td><pre><xsl:apply-templates/></pre></td></tr>
  </table>
</xsl:template>

<xsl:template match="syntax">
  <table class="codebox" cellspacing="0" border="0" cellpadding="3" width="500">
    <tr><td><pre><xsl:apply-templates/></pre></td></tr>
  </table>
</xsl:template>

<xsl:template match="desc"><xsl:apply-templates/></xsl:template>
<xsl:template match="codefragment">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="callseq"><xsl:apply-templates/></xsl:template>

<xsl:template match="obj"><i><xsl:apply-templates/></i></xsl:template>

<xsl:template match="center"><center><xsl:apply-templates/></center></xsl:template>
<xsl:template match="cmdopt"><code><xsl:apply-templates/></code></xsl:template>
<xsl:template match="code"><code><xsl:apply-templates/></code></xsl:template>
<xsl:template match="meth"><code><xsl:apply-templates/></code></xsl:template>
<xsl:template match="var"><code><xsl:apply-templates/></code></xsl:template>
<xsl:template match="kw"><code><xsl:apply-templates/></code></xsl:template>
<xsl:template match="nt"><i><xsl:apply-templates/></i></xsl:template>
<xsl:template match="const"><code><xsl:apply-templates/></code></xsl:template>

<xsl:template match="variable">
  <table border="0">
    <tr>
      <td width="60" align="top">
        <xsl:value-of select="./@name"/>
      </td>
      <td width="60" align="top">
        <xsl:value-of select="./@type"/>
      </td>
      <td align="top">
        <xsl:apply-templates/>
      </td>
    </tr>
  </table>
</xsl:template>

<xsl:template match="table">
  <table class="codebox" cellspacing="0" border="0" cellpadding="3">
    <xsl:apply-templates/>
  </table>
</xsl:template>

<xsl:template match="rubycode">
  <table class="codebox" cellspacing="0" border="0" cellpadding="3" width="500">
    <xsl:apply-templates/>
  </table>
</xsl:template>

<!-- we ignore fullcode : it's there to get code bodies inlinefor Clemens -->
<xsl:template match="fullcode"/>

<xsl:template match="th">
  <tr bgcolor="#ff9999"><xsl:apply-templates/></tr></xsl:template>
<xsl:template match="tr"><tr><xsl:apply-templates/></tr></xsl:template>
<xsl:template match="td">
  <xsl:if test="./@colspan">
    <td colspan="{./@colspan}" valign="top">
      <xsl:apply-templates/>
    </td>
  </xsl:if>
  <xsl:if test="not(./@colspan)">
    <td valign="top">
      <xsl:apply-templates/>
    </td>
  </xsl:if>
</xsl:template>

<xsl:template match="toprule">
  <tr><td colspan="9" bgcolor="#ff9999" height="3"><img
  src="dot.gif" width="1" height="1"></img></td></tr>
</xsl:template>

<xsl:template match="midrule">
  <tr height="1"><td colspan="9" bgcolor="#ffaaaa"><img
  src="dot.gif" width="1" height="1"></img></td></tr>
</xsl:template>

<xsl:template match="multicolsep">
  <td width="5"></td>
  <td bgcolor="#ffaaaa" width="2"><img
  src="dot.gif" width="1" height="1"></img></td>
  <td width="5"></td>
</xsl:template>

<xsl:template match="bottomrule">
  <tr><td colspan="9" bgcolor="#ff9999" height="2"><img
  src="dot.gif" width="1" height="1"></img></td></tr>
</xsl:template>

<xsl:template match="block"><xsl:apply-templates/></xsl:template>
<xsl:template match="blockbody"><xsl:apply-templates/></xsl:template>
<xsl:template match="returns">-> <xsl:apply-templates/></xsl:template>

<xsl:template match="alltt"><pre><xsl:apply-templates/></pre></xsl:template>
<xsl:template match="b"><b><xsl:apply-templates/></b></xsl:template>
<xsl:template match="u"><u><xsl:apply-templates/></u></xsl:template>
<xsl:template match="br"><br><xsl:apply-templates/></br></xsl:template>
<xsl:template match="hr"><hr><xsl:apply-templates/></hr></xsl:template>
<xsl:template match="blockquote"><blockquote><xsl:apply-templates/></blockquote></xsl:template>

<xsl:template match="caption"><b><xsl:apply-templates/></b></xsl:template>

<xsl:template match="opt">
   <i>[</i>
     <xsl:apply-templates/>
   <i>]</i>
</xsl:template>

<xsl:template match="optz">
   <i>[</i>
     <xsl:apply-templates/>
   <i>]<sup>*</sup></i>
</xsl:template>

<xsl:template match="optn">
   <i>[</i>
     <xsl:apply-templates/>
   <i>]<sup>+</sup></i>
</xsl:template>

<xsl:template match="exception"><code><xsl:apply-templates/></code></xsl:template>
<xsl:template match="methodname"><code><xsl:apply-templates/></code></xsl:template>
<xsl:template match="classname"><code><xsl:apply-templates/></code></xsl:template>
<xsl:template match="modulename"><code><xsl:apply-templates/></code></xsl:template>

<xsl:template match="subclasses">
  <br/><font size="-1">Subclasses: <xsl:apply-templates/></font>
  <p/>
</xsl:template>
<!-- general formatting -->

<xsl:template match="em"><em><xsl:apply-templates/></em></xsl:template>
<xsl:template match="tt"><code><xsl:apply-templates/></code></xsl:template>
<xsl:template match="smallfont">
  <font size="-2"><xsl:apply-templates/></font>
</xsl:template>

<xsl:template match="footnote"> <em>[<xsl:apply-templates/>]</em></xsl:template>

<xsl:template match="figure">
  <table border="2" width="500" bgcolor="#ffe0e0">
    <tr><td>
      <xsl:apply-templates/>
    </td></tr>
  </table>
</xsl:template>

<xsl:template match="sidebar">
  <p/>
  <table width="500" border="2" cellpadding="15" bgcolor="#ffe0e0" align="center">
    <tr><td align="center"><b>Sidebar: <xsl:value-of select="./@name"/></b></td></tr>
    <tr><td>
      <xsl:apply-templates/>
    </td></tr>
  </table><p/>
</xsl:template>

<!-- names of methods. We generate a hyperlink -->

<xsl:template name="methref">
  <xsl:param name="sep"/>
  <xsl:param name="cm"/>
  <xsl:if test="./file">
    <a href="ref_{$cm}_{./file}.html#{./front}.{./mref}">
   <code>
    <xsl:value-of select="./front"/>
    <xsl:value-of select="$sep"/>
    <xsl:value-of select="./back"/>
   </code>
    </a>
  </xsl:if>
  <xsl:if test="not(./file)">
   <code>
    <xsl:value-of select="./front"/>
    <xsl:value-of select="$sep"/>
    <xsl:value-of select="./back"/>
   </code>
  </xsl:if>
</xsl:template>

<xsl:template match="cim">
  <xsl:call-template name="methref">
     <xsl:with-param name="sep">#</xsl:with-param>
     <xsl:with-param name="cm">c</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="ccm">
  <xsl:call-template name="methref">
     <xsl:with-param name="sep">.</xsl:with-param>
     <xsl:with-param name="cm">c</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="classconst">
  <xsl:call-template name="methref">
     <xsl:with-param name="sep">::</xsl:with-param>
     <xsl:with-param name="cm">c</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="moduleconst">
  <xsl:call-template name="methref">
     <xsl:with-param name="sep">::</xsl:with-param>
     <xsl:with-param name="cm">m</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="mim">
  <xsl:call-template name="methref">
     <xsl:with-param name="sep">#</xsl:with-param>
     <xsl:with-param name="cm">m</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="mmm">
  <xsl:call-template name="methref">
     <xsl:with-param name="sep">::</xsl:with-param>
     <xsl:with-param name="cm">m</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!-- list stuff -->
<xsl:template match="ul"><ul><xsl:apply-templates/></ul></xsl:template>
<xsl:template match="ol"><ol><xsl:apply-templates/></ol></xsl:template>
<xsl:template match="dl"><dl><xsl:apply-templates/></dl></xsl:template>

<xsl:template match="li"><li><xsl:apply-templates/></li></xsl:template>

<xsl:template match="dd"><dd><xsl:apply-templates/></dd></xsl:template>
<xsl:template match="dt"><dt><xsl:apply-templates/></dt></xsl:template>

<xsl:template match="sup"><sup><xsl:apply-templates/></sup></xsl:template>
<xsl:template match="sub"><sub><xsl:apply-templates/></sub></xsl:template>

<!-- visible space. for now we'll use a space with a distinct
     background. Maybe we could use an image in the future
-->

<xsl:template match="visible_space">
    <img src="visible_space.gif" width="15" height="10" align="bottom" alt="[visible space]"/>
</xsl:template>

<xsl:template match="url">
  <a href="{.}"><xsl:apply-templates/></a>
</xsl:template>

<xsl:template match="sansfont">
  <span class="sans"><xsl:apply-templates/></span>
</xsl:template>

<!-- function definitions in the ext_ruby chapter -->

  <xsl:template match="cdoctitle">
    <tr><th colspan="2" align="center"><xsl:apply-templates/></th></tr>
  </xsl:template>

  <xsl:template match="cfunc">
    <tr>
      <td>
        <tt><xsl:apply-templates select="./creturns"/>&#160;</tt>
      </td>
      <td>
        <tt>
          <b><xsl:value-of select="./@name"/></b>(<xsl:apply-templates select="./cparams"/>)
        </tt>
      </td>
    </tr>
    <tr>
      <td>&#160;</td>
      <td>
        <xsl:apply-templates select="./cbody"/>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="creturns"><xsl:apply-templates/></xsl:template>
  <xsl:template match="cbody"><xsl:apply-templates/></xsl:template>
  <xsl:template match="cparams"><xsl:apply-templates/></xsl:template>

<!-- document structuring -->

  <xsl:template match="chapter">
    <h1><xsl:apply-templates select="attribute::name"/></h1>
    <hr/>
    <br/>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="section">
    <h2><xsl:text disable-output-escaping="yes">&lt;a name="S</xsl:text>
    <xsl:number level="single" count="section" format="1" />
    <xsl:text disable-output-escaping="yes">"&gt;</xsl:text>
    <xsl:apply-templates/>
    <xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text></h2>
  </xsl:template>

  <xsl:template match="subsection|subsubsection">
    <h3><xsl:text disable-output-escaping="yes">&lt;a name="U</xsl:text>
    <xsl:number level="single" count="subsection|subsubsection" format="A" />
    <xsl:text disable-output-escaping="yes">"&gt;</xsl:text>
    <xsl:apply-templates/>
    <xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text></h3>
  </xsl:template>

  <!-- error on unmatched tag -->
<xsl:template match="*">
  <xsl:message>
     Unhandled XML element: <xsl:value-of select="local-name()"/>
  </xsl:message>
</xsl:template>

</xsl:stylesheet>
