#
# class to read a file, expanding \inputs
#
class NestedIO

  def initialize(stream)
    @ip = stream
    @ipStack = []
  end

  # Yield successive lines, making \input transparent
  def each
    loop do
      while (line = @ip.gets).nil?    # unstack at end of file
        @ip.close
        return nil if @ipStack.empty?
        @ip, @prefix = @ipStack.pop
      end

      # otherwise look for file inclusion.

      while line =~ /^\s*\\input\s*(\S+)\.txi/ 
        
        @ipStack.push [ @ip, @prefix ]
        @ip = File.new("../latex/" + $1 + ".tip")
        $stderr.puts "  .. #$1"
        line = @ip.gets
      end
      
      yield line
    end
  end
end

NestedIO.new(STDIN).each {|line| puts line}
