# We contain a list of the chapters in the book. From this
# we generate control the generation of the HTML files

CONTENTS = 
  [
  "foreword",
  "preface",
  "roadmap",
  "intro",
  "tut_classes",
  "tut_containers",
  "tut_stdtypes",
  "tut_methods",
  "tut_expressions",
  "tut_exceptions",
  "tut_modules",
  "tut_io",
  "tut_threads",
  "trouble",
  "rubyworld",
  "web",
  "ext_tk",
  "win32",
  "ext_ruby",
  "language",
  "classes",
  "taint",
  "ospace",

  [
    "ref_c_array",
    "ref_c_bignum",
    "ref_c_binding",
    "ref_c_class",
    "ref_c_continuation",
    "ref_c_dir",
    "ref_c_exception",
    "ref_c_falseclass",
    "ref_c_file",
    "ref_c_file__stat",
    "ref_c_fixnum",
    "ref_c_float",
    "ref_c_hash",
    "ref_c_integer",
    "ref_c_io",
    "ref_c_matchingdata",
    "ref_c_method",
    "ref_c_module",
    "ref_c_nilclass",
    "ref_c_numeric",
    "ref_c_object",
    "ref_c_proc",
    "ref_c_range",
    "ref_c_regexp",
    "ref_c_string",
    "ref_c_struct",
    "ref_c_struct__tms",
    "ref_c_symbol",
    "ref_c_thread",
    "ref_c_threadgroup",
    "ref_c_time",
    "ref_c_trueclass",
    "ref_m_comparable",
    "ref_m_enumerable",
    "ref_m_errno",
    "ref_m_filetest",
    "ref_m_gc",
    "ref_m_kernel",
    "ref_m_marshal",
    "ref_m_math",
    "ref_m_objectspace",
    "ref_m_process",
  ],
 
 "lib_standard",
  "lib_patterns",
  "lib_network",
  "lib_windows",
  "rdtool",
  "irb",
  "support",
]


#
# class to read a file, expanding \inputs
#
class NestedIO

  def initialize(stream)
    @ip = stream
    @ipStack = []
  end

  # Yield successive lines, making \input transparent
  def each
    loop do
      while (line = @ip.gets).nil?    # unstack at end of file
        @ip.close
        return nil if @ipStack.empty?
        @ip, @prefix = @ipStack.pop
      end

      # otherwise look for file inclusion.

      while line =~ /^\s*\\input\s*(\S+)\.txi/ 
        
        @ipStack.push [ @ip, @prefix ]
        @ip = File.new("../latex/" + $1 + ".tip")
        puts "  .. #$1"
        line = @ip.gets
      end
      
      yield @prefix, line
    end
  end
end

#
# Preprocess .tip files into tmp/xxx.txi, expanding code
# in the process
#

def preprocessTIPs(toDo)
  toDo.each_flat do |file|
    latexFile = "../latex/#{file}.tip"
    txiFile   = "tmp/#{file}.txi"
    puts txiFile
    IO.popen("(cd ../latex && ruby -I ../util ../util/code.rb) >#{txiFile}", "w") do |p|

      io = NestedIO.new(File.new(latexFile))

      io.each {|line| p.write line }
    end
    exit $? if $? != 0
  end
end

def generateXML(toDo)
  toDo.each_flat do |file|
    txiFile = "tmp/#{file}.txi"
    xmlFile = "xml/#{file}.xml"

    system "ruby tip2xml.rb <#{txiFile} >#{xmlFile}"
    exit $? if $? != 0
  end
end


def generateContents
  File.open("xml/contents.xml", "w") do |f|
    f.puts "<contents>\n"
    f.puts "</contents>\n"
  end
end

#################################################################33
#
# Main program
#

if ARGV.size == 0
  toDo = CONTENTS
else
  toDo = ARGV
end

def toDo.each_flat
  self.each do |element|
    if element.kind_of?(Array)
      element.each {|i| yield i}
    else
      yield element
    end
  end
end


preprocessTIPs(toDo)
generateXML(toDo)
