#!/usr/bin/perl -w
use strict;

require "tidyName.pl";

sub extract {
  my $text = shift;
  my $cm = shift;

  $cm = $cm ? "class" : "instance";
  
  while ($text =~ /\\begin\{method\}\{(.*?)\}/g) {
    my $meth = $1;
    $meth =~ s/\\,//g;
    $meth =~ s/\\_/_/g;
    $meth =~ s/\\%/%/g;
    $meth =~ s/\\&/&/g;
    $meth =~ s/\\up/^/g;
    $meth =~ s/\\sd/~/g;
    $meth =~ s/\\bq/`/g;
    $meth =~ s/--/-/g;

    my $ref = tidyName($meth);

    $meth =~ s/\&/\&amp;/g;
    $meth =~ s/</\&lt;/g;
    $meth =~ s/>/\&gt;/g;

    print "\t<meth name=\"$meth\" type=\"$cm\" ref=\"$ref\"/>\n";
  }
}

# Using the list of files on the command line, generate the index of
# library modules

undef $/;

print "<index>\n";

for my $file (@ARGV) {

  open(F, $file) or die $!;
  $_ = <F>;
  close(F);

  # Remove comments
  s/\\%//g;
  s/%.*//g;
  s//\%/g;

  /\\begin\{(class|module)\}\{(.*?)\}/ or die "No class|module";
  my $type = $1;
  my $name = $2;

  $file =~ s{^[./]*(latex/?)}{};
  $file =~ s/\.tip$//;
  
  print "<module type=\"$type\" name=\"$name\" file=\"$file\">\n";

  s/\\largesym\{(.*?)\}/$1/g;
  s/\{\}//g;

#  print "\n\nALL: <<$_>>\n\n";
  if (/begin\{classmethods\}(.*)\\end\{classmethods\}/s) {
    extract($1, 1);
  }
  
  if (/begin\{methods\}(.*)\\end\{methods\}/s) {
    extract($1, 0);
  }
  
  if (/begin\{privatemethods\}(.*)\\end\{privatemethods\}/s) {
    extract($1, 0);
  }
  
  print "</module>\n";
}

print "</index>\n";
