my %map =
  (
   '[' => '_ob',
   ']' => '_cb',
   '?' => '_qm',
   '!' => '_oh',
   ',' => '_cm',
   '%' => '_pc',
   '~' => '_sd',
   '+' => '_pl',
   '-' => '_mi',
   '*' => '_st',
   '/' => '_sl',
   '<' => '_lt',
   '>' => '_gt',
   '=' => '_eq',
   '`' => '_bq',
   '@' => '_at',
   '^' => '_up',
   '&' => '_et',
   '|' => '_ba'
  );

my $pattern = quotemeta(join('', keys(%map)));

sub tidyName {
  my $name = shift;
  my $oname = $name;

  $name =~ s/&amp;/\&/g;
  $name =~ s/&lt;/</g;
  $name =~ s/\\sd/~/g;
  $name =~ s/\(backquote\)//;
  $name =~ s/\s+//g;
  $name =~ s/!!//g;
  $name =~ s/\\largesym\{:(\d\d\d\d):(.*)\}:\1:/$2/;
  $name =~ s/[$pattern]/ $map{$&} /ego;
  print STDERR "'$oname': Unhandled character in $name\n" unless $name =~ /^[\w\d]+$/;
  $name
}

1;
