
Precision.append_features(NegativeNumber)

def NegativeNumber.induced_from(n)
  if (n.type == Fixnum)
      return NegativeNumber.new(-(n.abs))
  end
  if (n.type == Float)
      return NegativeNumber.new(-1.0 * (n.abs))
  end
  raise "Can't convert " + n.type.to_s
end

def Float.induced_from(n)
  if (n.type == NegativeNumber)
    return n.getFloat
  end
  super.induced_from(n)
end

def Integer.induced_from(n)
  if (n.type == NegativeNumber)
    return n.getInt
  end
  super.induced_from(n)
end
