=begin
= Synopsis

   require "tempfile"

   tf = Tempfile.new("afile")
   tf.path
   tf.puts("Cosi Fan Tutte")
   tf.close
   tf.open
   tf.gets
   tf.close(true)

= Description

Class (({Tempfile})) creates managed temporary files. Although they
behave like any other (({IO})) object, temporary files are automatically
deleted when the Ruby program terminates. Once a (({Tempfile})) object
has been created, the underlying file may be opened and closed a number
of times in succession.

(({Tempfile})) does not directly inherit from (({IO})). Instead, it
delegates calls to a (({File})) object. From the programmer's
perspective, apart from the unusual ((<(({new}))|Tempfile.new>)),
((<(({open}))|Tempfile#open>)), and ((<(({close}))|Tempfile#close>))
semantics, a (({Tempfile})) object behaves as if it were an (({IO}))
object.

= Class Methods

--- Tempfile.new( basename, tmpdir=see below ) 
    Constructs a temporary file in the given directory. The filename
    is built by concatenating ((|basename|)), the current process id,
    and (as an extension) a unique sequence number. If the ((|tmpdir|))
    parameter is not supplied, it defaults to the value of one of the
    environment variables (({TMPDIR})), (({TMP})), or (({TEMP})), or to
    the directory (({/tmp})).  The file is then opened using mode
    ``w+'', which allows reading and writing and deletes any
    existing content.

--- Tempfile.open( basename, tmpdir )
     Synonym for ((<Tempfile.new>)).

= Instance Methods

--- Tempfile#open
    Reopens ((|aTempfile|)) using mode ``r+'', which allows reading and
    writing but does not delete existing content.
  
--- Tempfile#close( final=false )
    Closes ((|aTempfile|)). If ((|final|)) is true, deletes the
    underlying real file. If ((|final|)) is false, ((|aTempfile|)) may
    be subsequently reopened. In all cases, the underlying file is
    deleted when the program terminates.  

--- Tempfile#path 
    Returns the full path of the underlying file.

= History

    $Id: tempfile.rd,v 1.1 2001/01/23 22:01:02 dave Exp $
=end
