;;; ri.el -- Emacs Lisp routines for Dave Thomas's "ri"
;;;          (Ruby Index) utility
;;
;; $Id: ri.el,v 1.1 2001/03/07 05:59:27 dave Exp $
;; $Author: dave $
;;
;; Version 0.01alpha
;;
;; David Alan Black
;; February 25, 2001
;;
;; Copyright David Alan Black, 2001
;; This software is distributed on the same terms
;; as Ruby itself.
;;
;;
;;; Usage:
;;
;; 1. If necessary, alter the variable ruby-index-ri-command
;;    (see first (setq), below).
;; 2. Evaluate the file.
;; 3. Start up index buffer: "M-x ruby-index"
;; 4. Once in the buffer, tab takes you word-by-word.  (Sort of.
;;    This is a little glitchy, but try it.)
;; 5. Hit <enter> on any index term and watch the magic!
;; 6. As new buffers open up, steps 4-5 will work.

;; You can also play around with the various functions,
;; most of which are defined as interactive.
;; For instance, ruby-index-show-term-at-point will do
;; about what it says.

(require 'thingatpt)

(setq ruby-index-ri-command "ri ")
(setq ruby-index-char-re "[A-Za-z#.:_]")
(setq ruby-index-term-re (concat "\\(" ruby-index-char-re "+\\)"))

(defun ruby-index-run-ri(&optional term)
  (shell-command-to-string
   (concat ruby-index-ri-command (or term ""))))

(defun ruby-index-entry(term)
  (interactive)
  (ruby-index-run-ri term))

(defun ruby-index-term-at-point()
  (interactive)
  (thing-at-point-looking-at ruby-index-term-re)
  (match-string 1))

(defun ruby-index-generate-buffer-name(&optional term)
  (or
   (and term (concat "**Ruby Index: " term "**"))
    "**Ruby Index**"))

(defun ruby-index-create-buffer(&optional term)
  (interactive)
  (let ((ribuffer (ruby-index-generate-buffer-name term)))
    (if (get-buffer ribuffer)
	nil
      (progn
	(set-buffer (get-buffer-create ribuffer))
	(insert (ruby-index-entry term))))
      (set-buffer ribuffer)
      (beginning-of-buffer)
      ribuffer))
 
(defun ruby-index-at-term-char()
  (thing-at-point-looking-at ruby-index-char-re))

(defun ruby-index-find-next-term()
  (interactive)
  (while (ruby-index-at-term-char)
    (forward-char))
  (while (not (ruby-index-at-term-char))
    (forward-char)))

(defun ruby-index-show-term-at-point()
  (interactive)
  (ruby-index-show (ruby-index-term-at-point)))

(defun ruby-index-show(&optional term)
  (let ((ribuffer (ruby-index-create-buffer term)))
    (display-buffer ribuffer)
    (switch-to-buffer-other-window ribuffer)
    (local-set-key "\C-m" 'ruby-index-show-term-at-point)
    (local-set-key "\C-i" 'ruby-index-find-next-term)
    ribuffer))

(defun ruby-index()
  (interactive)
  (ruby-index-show))


