<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0"
                extension-element-prefixes="xt">

<xsl:output method="xml" encoding="iso-8859-1"/>

<xsl:template match="/">
  <simple>
    <xsl:apply-templates/>
  </simple>
</xsl:template>

<xsl:template match="ppdoc">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="copyright">
</xsl:template>

<xsl:template match="p">
  <p/>
</xsl:template>

<xsl:template match="nbsp">
  <xsl:text> </xsl:text>
</xsl:template>

<!-- Constants in module definitions -->
<xsl:template match="constants">
</xsl:template>

<xsl:template match="noTableConstants">
  <constants>
    <xsl:apply-templates/>
  </constants>
</xsl:template>

<xsl:template match="constant">
  <constant>
    <xsl:apply-templates/>
  </constant>
</xsl:template>

<xsl:template match="constname">
  <constname><xsl:apply-templates/></constname>
</xsl:template>

<xsl:template match="constval">
  <constval><xsl:apply-templates/></constval>
</xsl:template>

<xsl:template match="constdesc">
  <constdesc><xsl:apply-templates/></constdesc>
</xsl:template>

<xsl:template match="library">
  <!--Library: <xsl:apply-templates select="attribute::name"/> -->
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="class">
  <class type="{./@type}" name="{./@name}" super="{./@super}">
    <xsl:apply-templates/>
  </class>
</xsl:template>

<xsl:template match="relieson">
</xsl:template>

<xsl:template match="methods">
  <methods type="{./@type}">
    <xsl:apply-templates/>
  </methods>
</xsl:template>

<xsl:template match="mixins">
</xsl:template>

<xsl:template match="mixin">
  <mixin name="{./@name}">
    <xsl:apply-templates/>
  </mixin>
</xsl:template>

<xsl:template match="method">
  <method name="{./@name}">
    <xsl:apply-templates/>
  </method>
</xsl:template>

<xsl:template match="callseq">
  <callseq>
    <xsl:apply-templates/>
  </callseq>
</xsl:template>

<xsl:template match="desc">
  <desc>
    <xsl:apply-templates/>
  </desc>
</xsl:template>


<!-- ignore <p> between methods -->
<xsl:template match="methods/p">
</xsl:template>

<!-- convet an alltt within a codefragment is code with no comment output -->
<xsl:template match="codefragment/alltt">
  <verbatim>
    <xsl:apply-templates/>
  </verbatim>
</xsl:template>

<!-- this is code with comments showing output --> 
<xsl:template match="codefragment/rubycode">
  <verbatim><xsl:text>
</xsl:text>
    <xsl:for-each select="tr">
        <xsl:if test="count(./td) = 1">
          <xsl:apply-templates select="td"/>
        </xsl:if>
        <xsl:if test="count(./td) != 1">
          <MULTI><m1><xsl:apply-templates select="./td[1]"/></m1><m2><xsl:apply-templates select="./td[3]"/></m2></MULTI>
        </xsl:if><xsl:text>
</xsl:text>
    </xsl:for-each>
  </verbatim>
</xsl:template>

<xsl:template match="codefragment/rubycode/tr/td">
  <xsl:apply-templates/>
</xsl:template>

<!-- we ignore the unabridged code -->
<xsl:template match="fullcode"/>

<xsl:template match="verbatim">
  <verbatim>
    <xsl:apply-templates/>
  </verbatim>
</xsl:template>

<xsl:template match="syntax">
  <verbatim>
    <xsl:apply-templates/>
  </verbatim>
</xsl:template>

<xsl:template match="codefragment">
  <xsl:apply-templates/>
</xsl:template>


<xsl:template match="obj"><i><xsl:apply-templates/></i></xsl:template>

<xsl:template match="center"><center><xsl:apply-templates/></center></xsl:template>
<xsl:template match="cmdopt"><code><xsl:apply-templates/></code></xsl:template>
<xsl:template match="code"><xsl:apply-templates/></xsl:template>
<xsl:template match="meth"><code><xsl:apply-templates/></code></xsl:template>
<xsl:template match="var"><code><xsl:apply-templates/></code></xsl:template>
<xsl:template match="kw"><code><xsl:apply-templates/></code></xsl:template>
<xsl:template match="nt"><i><xsl:apply-templates/></i></xsl:template>
<xsl:template match="const"><code><xsl:apply-templates/></code></xsl:template>

<xsl:template match="variable">
  <table border="0">
    <tr>
      <td width="60" align="top">
        <xsl:value-of select="./@name"/>
      </td>
      <td width="60" align="top">
        <xsl:value-of select="./@type"/>
      </td>
      <td align="top">
        <xsl:apply-templates/>
      </td>
    </tr>
  </table>
</xsl:template>

<xsl:template match="table">
  <table bgcolor="#fff0f0" cellspacing="0" border="0" cellpadding="3">
    <xsl:apply-templates/>
  </table>
</xsl:template>

<xsl:template match="rubycode">
    <xsl:apply-templates/>
</xsl:template>

<xsl:template match="th">
  <th><xsl:apply-templates/></th>
</xsl:template>
<xsl:template match="tr"><tr><xsl:apply-templates/></tr></xsl:template>
<xsl:template match="td">
  <xsl:if test="./@colspan">
    <td colspan="{./@colspan}">
      <xsl:apply-templates/>
    </td>
  </xsl:if>
  <xsl:if test="not(./@colspan)">
    <td>
      <xsl:apply-templates/>
    </td>
  </xsl:if>
</xsl:template>

<xsl:template match="toprule">
  <toprule/>
</xsl:template>

<xsl:template match="midrule">
  <midrule/>
</xsl:template>

<xsl:template match="multicolsep">
</xsl:template>

<xsl:template match="bottomrule">
  <bottomrule/>
</xsl:template>

<xsl:template match="block"><xsl:apply-templates/></xsl:template>
<xsl:template match="blockbody"><xsl:apply-templates/></xsl:template>
<xsl:template match="returns">-> <xsl:apply-templates/></xsl:template>

<xsl:template match="alltt"><pre><xsl:apply-templates/></pre></xsl:template>
<xsl:template match="b"><b><xsl:apply-templates/></b></xsl:template>
<xsl:template match="u"><u><xsl:apply-templates/></u></xsl:template>
<xsl:template match="br"><br><xsl:apply-templates/></br></xsl:template>
<xsl:template match="hr"><hr><xsl:apply-templates/></hr></xsl:template>
<xsl:template match="blockquote"><blockquote><xsl:apply-templates/></blockquote></xsl:template>
<xsl:template match="sub"><xsl:apply-templates/></xsl:template>
<xsl:template match="sup"><xsl:apply-templates/></xsl:template>

<!-- We cheat with ul -->

<xsl:template match="ul"><xsl:apply-templates/></xsl:template>
<xsl:template match="li"><p/>* <xsl:apply-templates/></xsl:template>

<xsl:template match="caption"><b><xsl:apply-templates/></b></xsl:template>

<xsl:template match="opt">
   <i>[</i> <xsl:apply-templates/> <i>]</i>
</xsl:template>

<xsl:template match="optz">
   <i>[</i> <xsl:apply-templates/> <i>]*</i>
</xsl:template>

<xsl:template match="optn">
   <i>[</i> <xsl:apply-templates/><i>]+></i>
</xsl:template>

<xsl:template match="exception"><code><xsl:apply-templates/></code></xsl:template>
<xsl:template match="methodname"><code><xsl:apply-templates/></code></xsl:template>
<xsl:template match="classname"><code><xsl:apply-templates/></code></xsl:template>
<xsl:template match="modulename"><code><xsl:apply-templates/></code></xsl:template>

<xsl:template match="subclasses">
  <subclasses>
    <xsl:apply-templates/>
  </subclasses>
</xsl:template>

<!-- general foratting -->

<xsl:template match="em"><em><xsl:apply-templates/></em></xsl:template>
<xsl:template match="tt"><code><xsl:apply-templates/></code></xsl:template>
<xsl:template match="smallfont">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="footnote"> <em>[<xsl:apply-templates/>]</em></xsl:template>

<xsl:template match="figure">
  <figure>
    <xsl:apply-templates/>
  </figure>
</xsl:template>

<!-- names of methods. We generate a hyperlink -->

<xsl:template name="methref">
  <xsl:param name="sep"/>
  <code>
    <xsl:value-of select="./front"/>
    <xsl:value-of select="$sep"/>
    <xsl:value-of select="./back"/>
  </code>
</xsl:template>

<xsl:template match="cim">
  <xsl:call-template name="methref">
     <xsl:with-param name="sep">#</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="ccm">
  <xsl:call-template name="methref">
     <xsl:with-param name="sep">::</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="classconst">
  <xsl:call-template name="methref">
     <xsl:with-param name="sep">::</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="moduleconst">
  <xsl:call-template name="methref">
     <xsl:with-param name="sep">::</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="mim">
  <xsl:call-template name="methref">
     <xsl:with-param name="sep">#</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="mmm">
  <xsl:call-template name="methref">
     <xsl:with-param name="sep">::</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!-- list stuff -->
<xsl:template match="XXul"><ul><xsl:apply-templates/></ul></xsl:template>
<xsl:template match="XXol"><ol><xsl:apply-templates/></ol></xsl:template>
<xsl:template match="XXdl"><dl><xsl:apply-templates/></dl></xsl:template>

<xsl:template match="XXli"><li></li></xsl:template>

<xsl:template match="XXdd"><dd></dd></xsl:template>
<xsl:template match="XXdt"><dt><xsl:apply-templates/></dt></xsl:template>

<xsl:template match="XXsup"><sup><xsl:apply-templates/></sup></xsl:template>
<xsl:template match="XXsub"><sub><xsl:apply-templates/></sub></xsl:template>

<!-- visible space. for now we'll use a space with a distinct
     background. Maybe we could use an image in the future
-->

<xsl:template match="visible_space">
  <xsl:text> </xsl:text>
</xsl:template>

<xsl:template match="url">
  <code><xsl:apply-templates/></code>
</xsl:template>

<xsl:template match="sansfont">
  <xsl:apply-templates/>
</xsl:template>

  <!-- error on unmatched tag -->
<xsl:template match="*">
  <xsl:message>
     Unhandled XML element: <xsl:value-of select="local-name()"/>
  </xsl:message>
</xsl:template>

</xsl:stylesheet>