require 'runit/testcase'

require "../refdoc.rb"
require "../ri.rb"

class TestRI < RUNIT::TestCase

  #######################################################################

  def test_defined?

    ri = RI.new
    
    not_defined = %w{ Array.new Fil File:St String.wombat String::wombat Wombat to_s }

    not_defined.each do |name|
      assert_nil(ri.defined?(name), name)
    end

    assert_equal("ClassModule", ri.defined?("File"))
    assert_equal("ClassModule", ri.defined?("File::Stat"))

    assert_equal("Method", ri.defined?("Array.to_s"))
    assert_equal("Method", ri.defined?("Array::new"))
  end


  #######################################################################

  def test_can_handle?
    ri = RI.new

    can_handle = %w{
         String Str File File::S String::new String::n String.n
         Str::new Array.to Array.to_s File:: to_s to compact!
      }

    can_handle.each do |name|
      assert(ri.can_handle?(name), name)
    end

    cannot_handle = %w{ 
         Stringxx Strong File::X Strong::new String::newxx
         wombat ::x ::new
    }

    cannot_handle.each do |name|
      assert(!ri.can_handle?(name), "Can't handle " + name)
    end

    assert(!ri.can_handle?(""))
  end
end

if __FILE__ == $0
  require 'runit/cui/testrunner'
  RUNIT::CUI::TestRunner.run(TestRI.suite)
end
