#!/usr/bin/env ruby

def extract(text, type)
  meths = []

  text.gsub!(/\\largesym\{(.*?)\}/) { $1 }
  text.gsub!(/[\{]\}/) { "!!" }
  text.scan /\\begin\{method\}\{(.*?)\}/ do |meth|
    meths << meth[0].gsub(/!!/, "{}")
  end
  "  \\ls#{type}meth\{#{meths.join(', ')}\}\n"
end

# Using the list of files on the command line, generate the index of
# library modules

puts '\\begin{librarysummary}';

ARGV.each do |file| 

  File.open(file) { |f| $_ = f.gets(nil) }

  gsub /%.*/, ''

  /\\begin\{(class|module)\}\{(.*?)\}/ or raise "No class|module"
  type = $1
  name = $2

  result = ""

  if (/begin\{classmethods\}(.*)\\end\{classmethods\}/m)
    result << extract($1, "class");
  end
  
  if (/begin\{methods\}(.*)\\end\{methods\}/m) 
    result << extract($1, "instance");
  end
  
  if (/begin\{privatemethods\}(.*)\\end\{privatemethods\}/m) 
    result << extract($1, "private");
  end
  
  if result.length > 0
    puts "\\begin\{ls#{type}\}\{#{name}\}"
    puts result
    puts "\\end\{ls#{type}\}"
  else
    puts "\\begin\{lsx#{type}\}\{#{name}\}"
    puts "\\end\{lsx#{type}\}"
  end

end

puts '\\end{librarysummary}';
