#
# raccp.rb
#
#   Copyright (c) 1999 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU Library General Public License.
#

require 'racc/parser'
require 'amstd/symbol'


module Racc

  class RaccParser < Parser

    def initialize( racc )
      @racc = racc
      @interf    = racc.interf
      @ruletable = racc.ruletable
    end


    attr :classname

    attr :filename

    def parse( str, fname, mydebug = false )
      fname.must String
      
      @scanner = RaccScanner.new( str )
      @scanner.debug    = @yydebug  = mydebug
      @scanner.filename = @filename = fname

      do_parse
    end


    private


    def next_token
      @scanner.scan
    end

    def on_error( tok, val, _values )
      case val
      when Symbol then v = val.id2name
      when String then v = val
      else
        v = val.inspect
      end
      raise ParseError,
%=parse error:#{@filename}:#{@scanner.lineno}: unexpected token '#{v}'=
    end

##### racc 0.14.1 generates ###

Racc_reduce_table = [
 0, 0, :racc_error,
 6, 20, :_reduce_1,
 0, 21, :_reduce_none,
 2, 21, :_reduce_none,
 3, 23, :_reduce_4,
 1, 23, :_reduce_none,
 2, 23, :_reduce_6,
 2, 24, :_reduce_7,
 3, 24, :_reduce_8,
 3, 25, :_reduce_9,
 3, 25, :_reduce_10,
 1, 27, :_reduce_none,
 2, 27, :_reduce_none,
 2, 28, :_reduce_13,
 2, 28, :_reduce_14,
 2, 28, :_reduce_15,
 1, 29, :_reduce_16,
 2, 29, :_reduce_17,
 1, 26, :_reduce_18,
 1, 26, :_reduce_19,
 1, 22, :_reduce_20,
 1, 30, :_reduce_21,
 2, 30, :_reduce_22,
 2, 30, :_reduce_23,
 2, 30, :_reduce_24,
 1, 31, :_reduce_none,
 1, 31, :_reduce_26,
 2, 31, :_reduce_27,
 1, 31, :_reduce_28 ]

Racc_reduce_n = 29

Racc_shift_n = 48

Racc_action_table = [
    21,    13,    45,    11,     9,    20,     8,     7,    16,    15,
    14,    39,    38,    42,    40,    41,    21,    21,    37,    21,
    21,    20,    20,    21,    20,    20,    21,    21,    20,    21,
    21,    20,    20,    21,    20,    20,    21,    35,    20,     6,
    33,    20,    16,    15,    14,    34,    16,    15,    14,    16,
    15,    14,     4,     3,    47,     1 ]

Racc_action_check = [
    26,     5,    27,     5,     5,    26,     5,     5,     7,     7,
     7,    26,    26,    26,    26,    26,    24,    29,    24,    40,
    31,    24,    29,    30,    40,    31,     9,    11,    30,    13,
    14,     9,    11,    15,    13,    14,    16,    23,    15,     4,
    18,    16,    18,    18,    18,    19,    19,    19,    19,     8,
     8,     8,     2,     1,    36,     0 ]

Racc_action_default = [
   -29,   -29,   -29,    -2,   -29,   -29,    48,   -29,   -29,   -29,
    -5,   -29,    -3,   -29,   -29,   -29,   -29,   -11,   -29,   -29,
   -19,   -18,    -6,   -29,   -29,   -21,   -20,   -29,   -16,   -15,
   -14,   -13,   -12,   -10,    -9,    -7,   -29,    -4,   -24,   -23,
   -29,   -28,   -26,   -25,   -22,    -1,   -17,    -8,   -27 ]

Racc_action_pointer = [
    53,    50,    52,   nil,    39,    -3,   nil,    -3,    38,    23,
   nil,    24,   nil,    26,    27,    30,    33,   nil,    31,    35,
   nil,   nil,   nil,    29,    13,   nil,    -3,    -3,   nil,    14,
    20,    17,   nil,   nil,   nil,   nil,    46,   nil,   nil,   nil,
    16,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil ]

Racc_goto_table = [
    22,     2,    23,    10,    25,    29,    30,    31,    32,    32,
    18,    19,    24,    12,    27,    36,     5,    43,    26,    44,
    46,    46,    46,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,    48 ]

Racc_goto_check = [
     7,     1,     7,     6,     7,    10,    10,    10,     9,     9,
     8,     8,     5,     4,     3,     7,     2,     7,    11,    12,
     7,     7,     7,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,     7 ]

Racc_goto_pointer = [
   nil,     1,    13,     1,     8,     1,    -2,    -9,     3,   -10,
    -9,     5,    -7 ]

Racc_goto_default = [
   nil,   nil,   nil,   nil,   nil,   nil,   nil,    28,   nil,    17,
   nil,   nil,   nil ]

Racc_token_table = {
 false => 0,
 Object.new => 1,
 :XCLASS => 2,
 :TOKEN => 3,
 :XRULE => 4,
 :XEND => 5,
 :XTOKEN => 6,
 :XSTART => 7,
 :STRING => 8,
 :XPRECHIGH => 9,
 :XPRECLOW => 10,
 :XLEFT => 11,
 :XRIGHT => 12,
 :XNONASSOC => 13,
 ";" => 14,
 ":" => 15,
 "|" => 16,
 "=" => 17,
 :ACTION => 18 }

Racc_nt_base = 19

Racc_arg = [
 Racc_action_table,
 Racc_action_check,
 Racc_action_default,
 Racc_action_pointer,
 Racc_goto_table,
 Racc_goto_check,
 Racc_goto_default,
 Racc_goto_pointer,
 Racc_nt_base,
 Racc_reduce_table,
 Racc_token_table,
 Racc_shift_n,
 Racc_reduce_n ]

Racc_debug_parser = false

##### racc system variables end #####


 # reduce 0 omitted

  def _reduce_1( val, _values, result )
      @interf.end_register_rule
      @classname = val[1].id2name
   result
  end

 # reduce 2 omitted

 # reduce 3 omitted

  def _reduce_4( val, _values, result )
      @interf.end_register_conv
   result
  end

 # reduce 5 omitted

  def _reduce_6( val, _values, result )
      @interf.register_start val[1]
   result
  end

  def _reduce_7( val, _values, result )
      @interf.register_conv( val[0], val[1] )
   result
  end

  def _reduce_8( val, _values, result )
      @interf.register_conv( val[1], val[2] )
   result
  end

  def _reduce_9( val, _values, result )
      @interf.end_register_prec( true )
   result
  end

  def _reduce_10( val, _values, result )
      @interf.end_register_prec( false )
   result
  end

 # reduce 11 omitted

 # reduce 12 omitted

  def _reduce_13( val, _values, result )
      @interf.register_prec( :Left, val[1] )
   result
  end

  def _reduce_14( val, _values, result )
      @interf.register_prec( :Right, val[1] )
   result
  end

  def _reduce_15( val, _values, result )
      @interf.register_prec( :Nonassoc, val[1] )
   result
  end

  def _reduce_16( val, _values, result )
      result = val
   result
  end

  def _reduce_17( val, _values, result )
      result.push val[1]
   result
  end

  def _reduce_18( val, _values, result )
      result = @interf.get_token( result )
   result
  end

  def _reduce_19( val, _values, result )
      result = @interf.get_token( eval '"' + val[0] + '"' )
   result
  end

  def _reduce_20( val, _values, result )
      unless result.empty? then
        @interf.register_from_array result
      end
   result
  end

  def _reduce_21( val, _values, result )
      result = val
   result
  end

  def _reduce_22( val, _values, result )
      result.push val[1]
   result
  end

  def _reduce_23( val, _values, result )
      unless result.empty? then
        @interf.register_from_array result
      end
      result.clear
   result
  end

  def _reduce_24( val, _values, result )
      pre = result.pop
      unless result.empty? then
        @interf.register_from_array result
      end
      result = [pre]
   result
  end

 # reduce 25 omitted

  def _reduce_26( val, _values, result )
      result = OrMark.new( @scanner.lineno )
   result
  end

  def _reduce_27( val, _values, result )
      result = Prec.new( val[1], @scanner.lineno )
   result
  end

  def _reduce_28( val, _values, result )
      result = Action.new( *result )
   result
  end

  end   # class RaccParser

end   # module Racc
